package com.xdja.safehelper;

import android.app.Activity;
import android.content.Context;

import java.util.Stack;

/**
 * Created by hyh on 2020/5/6.
 */
public class ActivityStackManager {

    private Stack<Activity> stack = new Stack<>();

    public void removeAll() {
        for (Activity activity : stack) {
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
        stack.clear();
    }

    public void add(Activity activity) {
        stack.add(activity);
    }

    public void remove(Activity activity) {
        stack.remove(activity);
    }


    private static ActivityStackManager instance;

    public static ActivityStackManager getInstance() {
        if (instance == null)
            instance = new ActivityStackManager();
        return instance;
    }
    /**
     * 返回当前应用内栈顶的activity
     *
     * @return
     */
    public Context getTopContext() {
        if (stack.size() <= 0) return null;
        return stack.get(0);
    }


}
