package com.xdja.safehelper.activity;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.KeyEvent;
import android.widget.TextView;


import com.xdja.safehelper.ActivityStackManager;
import com.xdja.safehelper.R;
import com.xdja.vhsm.utils.ViewUtils;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;


/**
 * Created by Administrator on 2017/4/15.
 */

public class BaseActivity extends Activity {
    protected String tag = "VHSM_Init";
    private LoadingDialog loadingDialog;

    protected Toolbar toolbar;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        //设置语言要放到  所有控件相关操作之前
        super.onCreate(savedInstanceState);
//        //默认设置竖屏
        if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        ActivityStackManager.getInstance().add(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        finishLoadingDialog();
        ActivityStackManager.getInstance().remove(this);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            handleKeyBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
    private TextView left_title_tv;
    /**
     * 初始化toolbar，<b>该方法必须在setContentView之后调用</b>
     *
     * @param isShowBackIcon 是否显示返回键
     * @param title          标题
     */
    protected void initToolbar(boolean isShowBackIcon, int title) {
//        left_title_tv = findViewById(R.id.left_title_tv);
//        left_title_tv.setText(title);
//
//        if (isShowBackIcon) {
//            Drawable lDrawable = getResources().getDrawable(R.drawable.icon_back) ;
//            left_title_tv.setCompoundDrawablesWithIntrinsicBounds(lDrawable,null,null,null);
//            left_title_tv.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View view) {
//                    handleKeyBack();
//                }
//            });
//        }

    }

    public void handleKeyBack() {
        if (ViewUtils.isKeyboardShown(this)) {
            ViewUtils.hideInputWindowDelay(this);
        } else {
            this.finish();
        }
    }

    public void showLoadingDialog(int msgId) {
        if (loadingDialog == null) {
            loadingDialog = new LoadingDialog(this);
        }

        if (!isShowDialog() && !isFinishing()) {
            loadingDialog.setContent(getString(msgId));
            loadingDialog.show();
        }
    }

    public void finishLoadingDialog() {
        if (isShowDialog()) {
            try{
                loadingDialog.dismiss();
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }

    /**
     * 是否正在展示 ProgressDialog
     *
     * @return
     */
    public boolean isShowDialog() {
        if (loadingDialog == null) {
            return false;
        }
        return loadingDialog.isShowing();
    }

    private MyCustomDialog netErrorDialog;

    /**
     * 网络异常弹框
     */
    public void showNetErrorDialog() {
        if (netErrorDialog == null) {
            netErrorDialog = new MyCustomDialog.Builder(this)
                    .setMessage(R.string.sh_net_error)
                    .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            dialogInterface.dismiss();
                        }
                    })
                    .create();
            netErrorDialog.setCancelable(false);
            netErrorDialog.setCanceledOnTouchOutside(false);
        }
        if (isFinishing()){
            return;
        }
        netErrorDialog.show();
    }


   private void showDialogAboutSingle(){
       if (netErrorDialog == null) {
           netErrorDialog = new MyCustomDialog.Builder(this)
                   .setMessage(R.string.sh_net_error)
                   .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                       @Override
                       public void onClick(DialogInterface dialogInterface, int i) {
                           dialogInterface.dismiss();
                       }
                   })
                   .create();
           netErrorDialog.setCancelable(false);
           netErrorDialog.setCanceledOnTouchOutside(false);
       }
       if (isFinishing()){
           return;
       }
       netErrorDialog.show();
   }
}
