package com.xdja.safehelper.activity;

import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;


import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.PersonInfo;
import com.xdja.safehelper.R;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.DialogRepository;

import io.reactivex.functions.Consumer;

public class BindIdentifyActivity extends BaseActivity {

    private NetRespositoryASync netRespositoryASync;
    public static String TAG_PHONE = "tag_phone";
    private String phone;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sh_layout_bind_identity);
        initView();
    }

    private EditText et_name, et_phone, et_ip, et_union;
    private Button btn_operate;

    private void initView() {

        initToolbar(true, R.string.sh_regist_apply);
        et_name = findViewById(R.id.et_name);
        et_phone = findViewById(R.id.et_phone);
        et_ip = findViewById(R.id.et_ip);
        et_union = findViewById(R.id.et_union);
        btn_operate = findViewById(R.id.btn_operate);

        phone = getIntent().getStringExtra(TAG_PHONE);
        et_phone.setText(phone);

        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showSubmitDialog();
            }
        });
        netRespositoryASync = new NetRespositoryASync();
    }


    private void showSubmitDialog() {
        String name = et_name.getText().toString();
        String phone = et_phone.getText().toString();
        String id = et_ip.getText().toString();
        String union = et_union.getText().toString();

        if (TextUtils.isEmpty(name)) {
            ToastUtils.makeText(BindIdentifyActivity.this, BindIdentifyActivity.this.getString(R.string.sh_name_and_phone_null,"姓名"), Toast.LENGTH_SHORT).show();
            return;
        }

        if (TextUtils.isEmpty(phone)){
            ToastUtils.makeText(BindIdentifyActivity.this, BindIdentifyActivity.this.getString(R.string.sh_name_and_phone_null,"手机号"), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!FuncUtils.isPhone(phone)) {
            ToastUtils.makeText(BindIdentifyActivity.this, BindIdentifyActivity.this.getString(R.string.sh_phone_invalid), Toast.LENGTH_SHORT).show();
            return;
        }
        String subDes = getString(R.string.sh_bind_submit, name, phone, id, union, phone);
        DialogRepository.showTextCenterHorizontalTwoBtnDialog(this, subDes, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                submit();
            }
        });
    }

    private void submit() {
        String name = et_name.getText().toString();
        String phone = et_phone.getText().toString();
        String ip = et_ip.getText().toString();
        String union = et_union.getText().toString();

        if (TextUtils.isEmpty(name) || TextUtils.isEmpty(phone)) {
            ToastUtils.makeText(BindIdentifyActivity.this, BindIdentifyActivity.this.getString(R.string.sh_name_and_phone_null), Toast.LENGTH_SHORT).show();
            return;
        }


        if (!TextUtils.isEmpty(ip)) {
            String str = FuncUtils.isIdentifier(ip);
            if (!str.equals("yes")) {
                ToastUtils.makeText(BindIdentifyActivity.this, str, Toast.LENGTH_SHORT).show();
                return;
            }
        }

        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        PersonInfo personInfo = new PersonInfo();
        personInfo.name = name;
        personInfo.identity = ip;
        personInfo.mobile = phone;
        personInfo.deptName = union;

        netRespositoryASync.registPersonInfo(personInfo, new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                BindIdentifyActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    BindIdentifyActivity.this.finish();
                } else if (integer == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                } else if (integer == ErrorCode.RET_PERSON_EXIST) {
                    ToastUtils.makeText(BindIdentifyActivity.this, R.string.sh_dev_reg_already_exist, Toast.LENGTH_SHORT).show();
                } else {
                    ToastUtils.makeText(BindIdentifyActivity.this, ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }


}
