package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.safehelper.R;
import com.xdja.safehelper.module.changepin.SHChangePinApply;
import com.xdja.safehelper.module.changepin.SHChangePinResultCallback;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.ChangePinPresenter;

/**
 * Created by hyh on 2020/4/15.
 */
public class ChangePinView extends AbstractCommonView<ChangePinPresenter> {

    private EditText et_old_pin, et_new_pin, et_conform_pin;
    private Button nick_ok;
    private TextView tvErrorInfo;


    @Override
    protected int getLayoutId() {
        return R.layout.sh_activity_change_password;
    }

    @Override
    protected void initContentView(View rootView) {
        et_old_pin = rootView.findViewById(R.id.et_old_pin);
        et_new_pin = rootView.findViewById(R.id.et_new_pin);
        et_conform_pin = rootView.findViewById(R.id.et_conform_pin);
        nick_ok = rootView.findViewById(R.id.nick_ok);
        tvErrorInfo = rootView.findViewById(R.id.tv_error_info);
    }

    @Override
    protected void bindContentViewEvent(View view) {
        et_old_pin.addTextChangedListener(new TextWatcher() {
            private CharSequence temp;

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (temp.length() >= 6 && et_new_pin.getText().length() >= 6 && et_conform_pin.length() >= 6) {
                    nick_ok.setEnabled(true);
                } else {
                    nick_ok.setEnabled(false);
                }
                tvErrorInfo.setVisibility(View.INVISIBLE);
            }
        });

        et_new_pin.addTextChangedListener(new TextWatcher() {
            private CharSequence temp;

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (temp.length() >= 6 && et_old_pin.getText().length() >= 6 && et_conform_pin.getText().length() >= 6) {
                    nick_ok.setEnabled(true);
                } else {
                    nick_ok.setEnabled(false);
                }
                tvErrorInfo.setVisibility(View.INVISIBLE);
            }
        });

        et_conform_pin.addTextChangedListener(new TextWatcher() {
            private CharSequence temp;

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (temp.length() >= 6 && et_old_pin.getText().length() >= 6 && et_new_pin.getText().length() >= 6) {
                    nick_ok.setEnabled(true);
                } else {
                    nick_ok.setEnabled(false);
                }
                tvErrorInfo.setVisibility(View.INVISIBLE);
            }
        });

        nick_ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                changePin();
            }
        });
    }

    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
    }

    private void changePin() {
        final String oldPin = et_old_pin.getText().toString();
        final String newPin = et_new_pin.getText().toString();
        final String conformPin = et_conform_pin.getText().toString();
        if (!newPin.equals(conformPin)) {
            tvErrorInfo.setVisibility(View.VISIBLE);
            tvErrorInfo.setText(R.string.sh_confirm_pin_equals);
            return;
        }
        tvErrorInfo.setVisibility(View.INVISIBLE);
        bindPresenter.changePin(oldPin, newPin, new SHChangePinApply(), new SHChangePinResultCallback(getActivity()));
    }

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return ChangePinView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_change_pin_title;
            }
        };
    }

    @Override
    public ChangePinPresenter binderPresenter() {
        return new ChangePinPresenter();
    }
}
