package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.initvhsm.net.bean.business.ApplyType;
import com.xdja.safehelper.R;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.CertInfo;

import com.xdja.safehelper.module.deviceinfo.ApplyResetInit;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.DeviceInfoPresenter;
import com.xdja.vhsm.mvp.view.DeviceInfoViewBase;
import com.xdja.vhsm.utils.ContextCache;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.CertItemView;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by hyh on 2020/4/14.
 */
public class DeviceInfoView extends DeviceInfoViewBase<DeviceInfoPresenter> {

    private View rootView;

    private TextView tvTip;

    @Override
    protected int getLayoutId() {
        return R.layout.sh_layout_device_info;
    }


    @Override
    protected void initContentView(View rootView) {
        this.rootView = rootView;
        tvTip = rootView.findViewById(R.id.tv_tip);
    }

    @Override
    protected void bindContentViewEvent(View view) {

    }

    private LoadingDialog loadingDialog;

    private ApplyResetInit resetInit;
    /**
     * 初版设计不需要展示重新初始化
     */
    private boolean isHideResetInit = true;

    @Override
    public void onCreate(Activity context) {
        loadingDialog = new LoadingDialog(context);
        super.onCreate(context);
        if (!isHideResetInit) {
            resetInit = new ApplyResetInit(getActivity(), loadingDialog, new ApplyResetInit.ResetInitCallback() {
                @Override
                public void resetInitSuccess() {
                    bindPresenter.initDeviceConfig();
                }

                @Override
                public Button getApplyButton() {
                    return applyReInitBtn;
                }
            });
        }
    }


    private ViewStub stub_empty_file;
    private TextView dev_flag;

    @Override
    public void inflateEmptyFileLayout() {
        if (stub_empty_file == null) {
            stub_empty_file = rootView.findViewById(R.id.stub_empty_file);
            stub_empty_file.inflate();
            dev_flag = rootView.findViewById(R.id.dev_flag);
        }
        dev_flag.setText(getActivity().getString(R.string.sh_empty_file, FuncUtils.getDevId(getActivity())));
        tvTip.setVisibility(View.GONE);
    }

    private ViewStub stub_cert_list;
    private TextView tv_devicd_id, tv_cardId;
    private LinearLayout ll_cert_list;

    @Override
    public void inflateCertListLayout() {
        if (stub_cert_list == null) {
            stub_cert_list = rootView.findViewById(R.id.stub_cert_list);
            stub_cert_list.inflate();
            tv_devicd_id = rootView.findViewById(R.id.tv_devicd_id);
            tv_cardId = rootView.findViewById(R.id.tv_cardId);
            ll_cert_list = rootView.findViewById(R.id.ll_cert_list);
        }
        String deviceId = FuncUtils.getDevId(getActivity());
        if (TextUtils.isEmpty(deviceId)) {
            return;
        }
        tv_devicd_id.setText(deviceId);
        tvTip.setVisibility(View.VISIBLE);
    }

    @Override
    public boolean preParserCardIdAndAllCerts() {
        if (loadingDialog.isShowing()) return false;

        loadingDialog.showLoading(R.string.sh_dev_cert_loading);
        return true;
    }

    @Override
    public void readCardIdAndAllCertCallback(Pair<String, List<CertInfo>> pair) {
        loadingDialog.finishLoadingDialog();
        showCertInfo(pair);
    }

    @Override
    public boolean preQueryApplyStatus() {
        if (isHideResetInit) return false;
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return false;
        }
        return true;
    }

    @Override
    public void queryApplyStatusCallback(Pair<Integer, ArrayList<TypeStatus>> pair) {
        if (getActivity().isFinishing() || getActivity().isDestroyed()) return;
        loadingDialog.finishLoadingDialog();
        if (pair.first == 0) {
            TypeStatus reInitTypeStatus = null;
            for (TypeStatus typeStatus : pair.second) {
                if (typeStatus.type == ApplyType.TYPE_REINIT) {
                    reInitTypeStatus = typeStatus;
                    break;
                }
            }
            if (reInitTypeStatus != null && resetInit != null) {
                resetInit.showBtnStatus(reInitTypeStatus.status);
            }
        } else if (pair.first == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(getActivity());
        } else {
            ToastUtils.makeText(getActivity(), ErrorMatcher.getErrorMsg(pair.first), Toast.LENGTH_SHORT).show();
        }
    }


    Button applyReInitBtn = null;

    private void showCertInfo(Pair<String, List<CertInfo>> pair) {

        String cardId = pair.first;
        tv_cardId.setText(cardId);
        tv_cardId.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean isCopy = FuncUtils.copy(tv_cardId.getText().toString());
                if (isCopy) {
                    ToastUtils.makeText(ContextCache.getContext(), R.string.sh_cardid_has_been_copeid, Toast.LENGTH_SHORT).show();
                }
            }
        });
        List<CertInfo> certInfos = pair.second;

        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        ll_cert_list.removeAllViews();
        if (certInfos == null || certInfos.size() == 0) {
            ll_cert_list.addView(getEmptyCertView(), lp);
            applyReInitBtn = rootView.findViewById(R.id.apply_reInit1);

        } else {
            for (CertInfo certInfo : certInfos) {
                ll_cert_list.addView(getCertItemView(certInfo), lp);
            }
            applyReInitBtn = rootView.findViewById(R.id.apply_reInit);
        }
        if (!isHideResetInit) {
            applyReInitBtn.setVisibility(View.VISIBLE);
        }
    }


    private CertItemView getCertItemView(CertInfo certInfo) {

        return new CertItemView(getActivity())
                .setCertType(certInfo.certType)
                .setContainer(certInfo.container + "")
                .setGiver(certInfo.issuerCN)
                .setUser(certInfo.subjectDN
                        .substring(0, certInfo.subjectDN.indexOf(",OU"))
                )
                .setValidPeriod(certInfo.validity)
                .setSN(certInfo.sn);
    }

    /**
     * 无证书View
     *
     * @return
     */
    private View getEmptyCertView() {
        return LayoutInflater.from(getActivity()).inflate(R.layout.sh_layout_empty_cert, null);
    }


    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return DeviceInfoView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_dev_info;
            }
        };
    }

    @Override
    public DeviceInfoPresenter binderPresenter() {
        return new DeviceInfoPresenter();
    }


}
