package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;

import com.xdja.safehelper.module.setting.SHQueryDeviceResultCallback;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.AboutVHSMActivity;
import com.xdja.safehelper.view.SHItemDecoration;
import com.xdja.vhsm.bean.SettingItemInfo;
import com.xdja.safehelper.module.setting.SHSettingItemData;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.SettingPresenter;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.SettingAdapter;

import java.util.List;

/**
 * Created by hyh on 2020/4/13.
 */
public class SettingView extends AbstractCommonView<SettingPresenter> {

    RecyclerView recyclerView;
    SettingAdapter adapter;
    TextView textVersion, textPrivacy;


    @Override
    protected int getLayoutId() {
        return R.layout.sh_activity_setting;
    }

    @Override
    protected void initContentView(View rootView) {
        textVersion = rootView.findViewById(R.id.activity_setting_version);

        textPrivacy = rootView.findViewById(R.id.activity_setting_privacy);

        recyclerView = rootView.findViewById(R.id.activity_setting_recyclerview);
        recyclerView.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        recyclerView.addItemDecoration(new SHItemDecoration(getActivity(), (int) getActivity().getResources().getDimension(R.dimen.base_48)))
        ;
        adapter = new SettingAdapter();
        recyclerView.setAdapter(adapter);
    }

    @Override
    protected void bindContentViewEvent(View view) {
    }

    private LoadingDialog loadingDialog;

    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
        initRecyclerView();
        String version = getActivity().getString(R.string.sh_setting_main_version) + bindPresenter.getVersion();
        textVersion.setText(version);
        loadingDialog = new LoadingDialog(context);
    }

    private void initRecyclerView() {
        List<SettingItemInfo> itemInfos = new SHSettingItemData(this).getSettingItemInfo();
        adapter.addInfo(itemInfos);
    }

    public void requestDeviceInfo(Class enterClass) {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return;
        }
        if (loadingDialog.isShowing()) return;
        loadingDialog.showLoading(R.string.sh_get_identify_loading);
        bindPresenter.queryDevice(new SHQueryDeviceResultCallback(this, enterClass));
    }

    @Override
    public void onResume() {
        super.onResume();
        adapter.notifyDataSetChanged();
    }

    public void finishLoadingDialog() {
        loadingDialog.dismiss();
    }

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return SettingView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_setting_title;
            }
        };
    }

    @Override
    public SettingPresenter binderPresenter() {
        return new SettingPresenter();
    }
}
