package com.xdja.safehelper.activity.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;


import com.xdja.safehelper.R;
import com.xdja.vhsm.mvp.common.ToolbarListener;

/**
 * Created by hyh on 2020/4/7.
 */
public class ToolbarWrapper {
    Context context;

    View view;
    private Toolbar toolbar;

    private TextView tvLeftTitle;

    private TextView tvRightText;

    private ImageView img_setting;

    ToolbarListener toolbarListener;

    public void initToolbar(ToolbarListener listener, View view) {
        this.toolbarListener = listener;
        this.view = view;
        context = view.getContext();
        initToolbarView(view);
        setViewVisibility();
        initToolbarListener();
        setContent();
    }


    void initToolbarView(View view) {
        toolbar = view.findViewById(R.id.toolbar);
        tvLeftTitle = view.findViewById(R.id.left_title_tv);
        tvRightText = view.findViewById(R.id.tv_refresh);
        img_setting = view.findViewById(R.id.tar_img_setting);
    }

    private void setViewVisibility() {
        if (!toolbarListener.isShowToolbar()) {
            view.setVisibility(View.GONE);
        }
        if (toolbarListener.isSupportLeftBack()) {
            Drawable lDrawable = context.getResources().getDrawable(R.drawable.sh_icon_back);
            tvLeftTitle.setCompoundDrawablesWithIntrinsicBounds(lDrawable, null, null, null);
        }
    }

    private void initToolbarListener() {
        tvLeftTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                toolbarListener.leftClickListener();
            }
        });
        tvRightText.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                toolbarListener.rightClickListener();
            }
        });
        img_setting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                toolbarListener.rightSetClickListener();
            }
        });
    }


    private void setContent() {
        if (toolbarListener.leftTitleResId() != 0) {
            tvLeftTitle.setText(toolbarListener.leftTitleResId());
        }
        if (toolbarListener.rightTitleResId() != 0) {
            tvRightText.setText(toolbarListener.rightTitleResId());
        }
        if (toolbarListener.rightSetIconResId() != 0) {
            img_setting.setVisibility(View.VISIBLE);
            img_setting.setImageResource(toolbarListener.rightSetIconResId());
        }
    }

}
