package com.xdja.safehelper.activity.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.initvhsm.net.bean.business.ApplyResult;
import com.xdja.initvhsm.net.bean.business.ResetApplyBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.OperateWithCodeActivity;
import com.xdja.safehelper.activity.SettingActivity;
import com.xdja.safehelper.activity.VhsmBindActivity;
import com.xdja.safehelper.activity.view.handle.Android10UpdateNoApplyHandle;
import com.xdja.safehelper.activity.view.handle.Android10UpdateSmsHandle;
import com.xdja.safehelper.activity.view.handle.DeviceIdGibberishHandle;
import com.xdja.safehelper.activity.view.handle.FileLostAgreeHandle;
import com.xdja.safehelper.activity.view.handle.FileLostNoApplyHandle;
import com.xdja.safehelper.activity.view.handle.FileLostNotApproveHandle;
import com.xdja.safehelper.activity.view.handle.FileLostRejectHandle;
import com.xdja.safehelper.activity.view.handle.FileLostSmsHandle;
import com.xdja.safehelper.activity.view.handle.HandleMain;
import com.xdja.safehelper.activity.view.handle.IllegalStateHandle;
import com.xdja.safehelper.activity.view.handle.LogoutHandle;
import com.xdja.safehelper.activity.view.handle.NetErrorHandle;
import com.xdja.safehelper.activity.view.handle.NormalForgetPinAgreeHandle;
import com.xdja.safehelper.activity.view.handle.NormalForgetPinNotApproveHandle;
import com.xdja.safehelper.activity.view.handle.NormalForgetPinRejectHandle;
import com.xdja.safehelper.activity.view.handle.NormalNotApplyHandle;
import com.xdja.safehelper.activity.view.handle.NormalSmsHandle;
import com.xdja.safehelper.activity.view.handle.NotRegisterHandle;
import com.xdja.safehelper.activity.view.handle.PinLockedAgreeHandle;
import com.xdja.safehelper.activity.view.handle.PinLockedNotApplyHandle;
import com.xdja.safehelper.activity.view.handle.PinLockedNotApproveHandle;
import com.xdja.safehelper.activity.view.handle.PinLockedRejectHandle;
import com.xdja.safehelper.activity.view.handle.PinLockedSmsHandle;
import com.xdja.safehelper.activity.view.handle.RegisterHasPersionInfoHandle;
import com.xdja.safehelper.activity.view.handle.RegisterNoPersionInfoHandle;
import com.xdja.safehelper.activity.view.handle.StopHandle;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.update.Update;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.InitFailDialog;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.VhsmManager;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.domain.VHSMBean;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.VHSMMainPresenter;
import com.xdja.vhsm.mvp.presenter.VhsmInitPresenter;
import com.xdja.vhsm.mvp.view.VHSMMainViewBase;
import com.xdja.vhsm.permission.SPermission;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;

import java.util.ArrayList;

public class VHSMMainViewNew extends AbstractCommonView<VHSMMainPresenter> implements VHSMMainViewBase<VHSMMainPresenter> {

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return VHSMMainViewNew.this.getActivity();
            }

            @Override
            public boolean isSupportLeftBack() {
                return false;
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_vhsm_manager;
            }

            @Override
            public void rightSetClickListener() {
                gotoSetting();
            }

            @Override
            public int rightSetIconResId() {
                return R.drawable.sh_setting;
            }

        };
    }

    @Override
    protected int getLayoutId() {
        return R.layout.sh_vhsm_main;
    }

    private TextView tv_cardId;
    private TextView tv_apply_status;
    private TextView tv_forgetPin;
    private Button btn_operate;
    private LoadingDialog loadingDialog;

    public TextView getTv_apply_status() {
        return tv_apply_status;
    }

    public TextView getTv_forgetPin() {
        return tv_forgetPin;
    }

    public Button getBtn_operate() {
        return btn_operate;
    }

    private boolean isFirst;

    public boolean isFirst() {
        return isFirst;
    }

    public void setFirst(boolean first) {
        isFirst = first;
    }

    private Dialog showDialog;

    public void setShowingDialog(Dialog dialog) {
        showDialog = dialog;
    }

    @Override
    protected void initContentView(View rootView) {
        isFirst = true;
        loadingDialog = new LoadingDialog(getActivity());

        tv_cardId = rootView.findViewById(R.id.tv_cardId);
        tv_apply_status = rootView.findViewById(R.id.tv_apply_status);
        btn_operate = rootView.findViewById(R.id.btn_operate);
        tv_forgetPin = rootView.findViewById(R.id.tv_forgetPin);

        hideViews();
    }

    @Override
    protected void bindContentViewEvent(View view) {
    }

    public void hideViews() {
        tv_cardId.setVisibility(View.GONE);
        tv_apply_status.setVisibility(View.GONE);
        btn_operate.setVisibility(View.GONE);
        tv_forgetPin.setVisibility(View.GONE);
    }


    /**
     * 进入设置页面
     */
    private void gotoSetting() {
        getActivity().startActivity(new Intent(getActivity(), SettingActivity.class));
    }


    @Override
    public void showVHSMStatus(VHSMBean vhsmBean) {
        loadingDialog.finishLoadingDialog();
        VhsmBean bean = vhsmBean.vhsmBean;
        handleVhsmBean(bean);
        Update.getInstance().checkUpdate(getActivity(), false);
    }

    private static ArrayList<HandleMain> handleList = new ArrayList<>();

    static {
        handleList.add(new NetErrorHandle());
        handleList.add(new LogoutHandle());
        handleList.add(new StopHandle());
        handleList.add(new RegisterHasPersionInfoHandle());
        handleList.add(new RegisterNoPersionInfoHandle());
        handleList.add(new NotRegisterHandle());
        handleList.add(new IllegalStateHandle());
        handleList.add(new FileLostSmsHandle());
        handleList.add(new FileLostNoApplyHandle());
        handleList.add(new FileLostNotApproveHandle());
        handleList.add(new FileLostAgreeHandle());
        handleList.add(new FileLostRejectHandle());
        handleList.add(new Android10UpdateSmsHandle());
        handleList.add(new Android10UpdateNoApplyHandle());
        handleList.add(new DeviceIdGibberishHandle());
        handleList.add(new PinLockedSmsHandle());
        handleList.add(new PinLockedNotApplyHandle());
        handleList.add(new PinLockedNotApproveHandle());
        handleList.add(new PinLockedAgreeHandle());
        handleList.add(new PinLockedRejectHandle());
        handleList.add(new NormalSmsHandle());
        handleList.add(new NormalNotApplyHandle());
        handleList.add(new NormalForgetPinNotApproveHandle());
        handleList.add(new NormalForgetPinAgreeHandle());
        handleList.add(new NormalForgetPinRejectHandle());
    }

    private void handleVhsmBean(VhsmBean vhsmBean) {
        for (HandleMain handle : handleList) {
            if (handle.canHandle(vhsmBean)) {
                handle.handle(this);
                if (handle instanceof NetErrorHandle){
                    return;
                }
                break;
            }
        }
        Update.getInstance().checkUpdate(getActivity(),false);
    }

    /**
     * 展示弹框
     *
     * @param res
     */
    public void showNotifyDialog(@StringRes int res) {
        MyCustomDialog dialog = DialogRepository.showNotifyDialog(getActivity(), getActivity().getString(res), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                getActivity().finish();
            }
        });
        setShowingDialog(dialog);
    }

    /**
     * 展示卡号
     */
    public void showCardId() {
        String cardId = VhsmManager.getInstance(getActivity()).getCardId();
        if (TextUtils.isEmpty(cardId)) {
            hideViews();
        } else {
            tv_cardId.setVisibility(View.VISIBLE);
            tv_cardId.setTextColor(getActivity().getResources().getColor(R.color.sh_cardId_color));
            tv_cardId.setTextSize(14);
            tv_cardId.setText(VhsmManager.getInstance(getActivity()).getCardId());
            tv_cardId.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.sh_detail, 0);
            tv_cardId.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    getActivity().startActivity(new Intent(getActivity(), DeviceInfoActivity.class));
                }
            });
        }
    }

    /**
     * 跳转到验证码页面
     *
     * @param mobile
     */
    public void gotoVerifyActivity(String mobile, String operate) {
        if (TextUtils.isEmpty(mobile)) {
            ToastUtils.makeText(getActivity(), R.string.sh_mobile_not_bind, Toast.LENGTH_LONG).show();
            return;
        }
        Intent intent = new Intent(getActivity(), OperateWithCodeActivity.class);
        intent.putExtra(OperateWithCodeView.TAG_MOBILE, mobile);
        intent.putExtra(OperateWithCodeView.TAG_OPERATE, operate);
        getActivity().startActivity(intent);
    }

    /**
     * 拒绝状态回显
     */
    public void sendRejectRequest(int applyType) {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            return;
        }
        bindPresenter.doSendRejectRequest(applyType);
    }

    /**
     * 初始化
     */
    private int num;

    public void doInit() {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return;
        }
        if (loadingDialog.isShowing()) {
            return;
        }
        loadingDialog.showLoading(R.string.sh_dev_init_loading);
        bindPresenter.doInit();
    }

    private void gotoVerifyPhone(String mobile) {
        Intent intent = new Intent(getActivity(), VhsmBindActivity.class);
        intent.putExtra(VhsmInitPresenter.MOBILE, mobile);
        getActivity().startActivity(intent);
    }

    @Override
    public void showReInitApplyResultView(int ret) {
        // not call
    }

    @Override
    public void showReInitResultView(int ret) {
        // not call
    }

    @Override
    public void showUnlockApplyResultView(int ret) {
        // not call
    }

    /**
     * 查询VHSM的状态
     */
    private void queryVHSMState() {
        bindPresenter.doQueryVHSMState();
    }

    @Override
    public void showUnlockResultView(ApplyResult applyResult) {
        // not call
    }

    @Override
    public void showInitResultView(int ret) {
        loadingDialog.finishLoadingDialog();
        if (ret == 0) {
            doRefresh();
            ToastUtils.makeText(getActivity(), getActivity().getString(R.string.sh_dev_init_success), Toast.LENGTH_SHORT).show();
        } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(getActivity());
        } else if (ret == ErrorCode.RET_UNBIND_PERSON) {
            gotoVerifyPhone("");
        } else if (ret == ErrorCode.RET_DEVICE_ACHIVE_MAX || ret == ErrorCode.RET_LICENSE_MAX_DEVICE) {
            ToastUtils.makeText(getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
        } else if (ret == ErrorCode.RET_COMPANY_DISABLE) {
            showNotifyDialog(R.string.sh_company_disable);
        } else {
            if (num == 0) {
                num++;
                showFailDialog();
            } else {
                ToastUtils.makeText(getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
            }
        }
    }

    private InitFailDialog initFailDialog;

    private void showFailDialog() {
        if (initFailDialog == null) {
            initFailDialog = new InitFailDialog(getActivity());
            initFailDialog.setPositiveButton(new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            initFailDialog.setTimeInter(new InitFailDialog.TimeInter() {
                @Override
                public void timeOut() {
                    doInit();
                }
            });
        }
        initFailDialog.show();
        initFailDialog.startTimer();
    }

    @Override
    public void showResetPinApplyView(int ret) {
        //no call
    }

    /**
     * 刷新
     */
    @Override
    public void doRefresh() {
        if (showDialog != null) {
            showDialog.dismiss();
        }
        hideViews();
        if (!NetUtils.isNetworkConnected(getActivity())) {
            NetErrorHandle handle = new NetErrorHandle();
            handle.handle(this);
        }
        if (loadingDialog.isShowing()) {
            return;
        }
        loadingDialog.showLoading(R.string.sh_device_status_loading);
        queryVHSMState();
    }

    @Override
    public void showQueryResetPinApplyStatus(ResetApplyBean resetApplyBean) {
        //not call
    }

    @Override
    public void showResetPinResultView(int ret) {
        //not call
    }

    @Override
    public void showReApplyResultView(final VHSMBean vhsmBean, Pair<Integer, ArrayList<TypeStatus>> integerArrayListPair) {
        // not call
    }

    @Override
    public void showPermissionDeniedDialog() {
        createCommonDialog(R.string.sh_getDevId_some_powers_has_forbid, R.string.sh_getDevId_some_powers_has_forbid_content
                , R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        getActivity().finish();
                    }
                }, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        SPermission.getsPermission().activeSPermission();
                        bindPresenter.requestPermissions();
                    }
                });
    }

    @Override
    public void showPermissionDeniedAlwaysDialog() {
        createCommonDialog(R.string.sh_acu_can_not_open_power_title, R.string.sh_acu_can_not_open_power_content1
                , R.string.sh_cancel, R.string.sh_acu_can_not_open_power_right_button
                , new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        getActivity().finish();
                    }
                }
                , new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        FuncUtils.getAppDetailSettingIntent(getActivity());
                    }
                });
    }

    @Override
    public VHSMMainPresenter binderPresenter() {
        return new VHSMMainPresenter();
    }

    private AlertDialog commonDialog;

    private void createCommonDialog(int titleRes, int contentRes,
                                    int leftButtonRes, int rightButtonRes,
                                    DialogInterface.OnClickListener leftButtonListener,
                                    DialogInterface.OnClickListener rightButtonListener) {
        commonDialog = new AlertDialog.Builder(getActivity())
                .setTitle(titleRes)
                .setMessage(contentRes)
                .setPositiveButton(rightButtonRes, rightButtonListener)
                .setNegativeButton(leftButtonRes, leftButtonListener)
                .create();
        commonDialog.setCanceledOnTouchOutside(false);
        commonDialog.setCancelable(false);
        commonDialog.show();
    }

    public View.OnClickListener getDoInitListener() {
        return doInitListener;
    }

    public View.OnClickListener getDoRegiserListener() {
        return doRegiserListener;
    }

    private View.OnClickListener doInitListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            doInit();
        }
    };

    private View.OnClickListener doRegiserListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Intent intent = new Intent(getActivity(), VhsmBindActivity.class);
            getActivity().startActivity(intent);
        }
    };

}
