package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.safehelper.activity.SettingActivity;
import com.xdja.safehelper.module.vhsmbind.SHBindPersonResultCallback;
import com.xdja.safehelper.module.vhsmbind.SHVhsmInitResultCallback;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BindIdentifyActivity;
import com.xdja.safehelper.module.vhsmbind.SHGetCodeResultCallback;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.vhsm.mvp.presenter.VhsmInitPresenter;
import com.xdja.vhsm.mvp.view.VhsmInitViewBase;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.InitFailDialog;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;

/**
 * Created by hyh on 2020/4/9.
 */
public class VhsmInitView extends VhsmInitViewBase<VhsmInitPresenter> {

    private TextView tv_tip, tv_get_code;

    private EditText et_phone, et_verify_code;

    private Button btn_operate;

    private ImageView ic_verify_code, ic_phone;

    private LoadingDialog loadingDialog;

    @Override
    public VhsmInitPresenter binderPresenter() {
        return new VhsmInitPresenter();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.sh_layout_verify_mobile;
    }

    @Override
    protected void initContentView(View rootView) {
        tv_tip = rootView.findViewById(R.id.tv_tip);
        et_phone = rootView.findViewById(R.id.et_phone);
        et_verify_code = rootView.findViewById(R.id.et_verify_code);
        tv_get_code = rootView.findViewById(R.id.tv_get_code);
        btn_operate = rootView.findViewById(R.id.btn_operate);
        ic_phone = rootView.findViewById(R.id.ic_phone);
        ic_verify_code = rootView.findViewById(R.id.ic_verify_code);
    }

    @Override
    protected void bindContentViewEvent(View view) {
        et_phone.addTextChangedListener(new TextWatcher() {
            private CharSequence temp;

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (temp.length() > 0 && et_verify_code.getText().length() > 0) {
                    btn_operate.setEnabled(true);
                } else {
                    btn_operate.setEnabled(false);
                }
                if (temp.length() > 0) {
                    setPhoneLeftIcon(true);
                } else {
                    setPhoneLeftIcon(false);
                }
            }
        });

        et_verify_code.addTextChangedListener(new TextWatcher() {

            private CharSequence temp;

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (temp.length() > 0 && et_phone.getText().length() > 0) {
                    btn_operate.setEnabled(true);
                } else {
                    btn_operate.setEnabled(false);
                }
                if (temp.length() > 0) {
                    setVerifyCodeLeftIcon(true);
                } else {
                    setVerifyCodeLeftIcon(false);
                }
            }
        });
        tv_get_code.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (preGetCode(et_phone.getText().toString())) {
                    bindPresenter.getCode(et_phone.getText().toString(), getCodeResultCallback);
                }
            }
        });


        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (preBindPerson(et_phone.getText().toString(), et_verify_code.getText().toString())) {
                    showLoadingDialog();
                    bindPresenter.bindPerson(et_phone.getText().toString(), et_verify_code.getText().toString(), bindPersonResultCallback);
                }
            }
        });
    }

    private ConsumerCallback getCodeResultCallback;
    private ConsumerCallback bindPersonResultCallback;
    private ConsumerCallback vhsmInitResultCallback;

    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
        loadingDialog = new LoadingDialog(context);
        loadingDialog.setVerticalLayout(true);
        if (bindPresenter.isEmptyExtrasMobile()) {
            tv_tip.setText(R.string.sh_tip);
            btn_operate.setText(R.string.sh_bind);
            setPhoneLeftIcon(false);
        } else {
            et_phone.setText(bindPresenter.mobile);
            et_phone.setEnabled(false);
            tv_tip.setText(R.string.sh_tip_regist_apply_agree);
            btn_operate.setText(R.string.sh_safe_verify);
            setPhoneLeftIcon(true);
        }
        tv_get_code.setText(R.string.sh_get_code);
        btn_operate.setEnabled(false);
        setVerifyCodeLeftIcon(false);
        getCodeResultCallback = new SHGetCodeResultCallback(this);
        bindPersonResultCallback = new SHBindPersonResultCallback(this);
        vhsmInitResultCallback = new SHVhsmInitResultCallback(this);
    }

    private boolean preGetCode(String mobile) {
        if (!verifyInputMobileInfo(mobile)) {
            return false;
        }
        if (!verifyNetWorkState()) {
            return false;
        }
        return true;
    }

    private boolean preBindPerson(String mobile, String code) {
        if (!verifyInputInfo(mobile, code)) {
            return false;
        }
        if (!verifyNetWorkState()) {
            return false;
        }
        if (loadingDialog.isShowing()) return false;
        return true;
    }


    public void timerStart(int time) {
        tv_get_code.setEnabled(false);
        tv_get_code.setText(getActivity().getString(R.string.sh_reget_code) + ("(" + time + ")"));
    }

    public void timerIng(int time) {
        tv_get_code.setText(getActivity().getString(R.string.sh_reget_code) + ("(" + time + ")"));
    }

    @Override
    public void timerFinish(int time) {
        tv_get_code.setEnabled(true);
        tv_get_code.setText(R.string.sh_get_code);
    }

    /**
     * 发送验证码成功回调
     */
    public void codeSendCallback() {
        tv_get_code.setEnabled(true);
        tv_get_code.setText(R.string.sh_get_code);
    }


    public void initVhsm() {
        if (!verifyNetWorkState()) {
            dismissLoadingDialog();
            return;
        }
        bindPresenter.doInit(vhsmInitResultCallback);
    }

    public boolean verifyInputMobileInfo(String mobile) {
        if (TextUtils.isEmpty(mobile)) {
            ToastUtils.makeText(getActivity(), getActivity().getString(R.string.sh_phone_null), Toast.LENGTH_SHORT).show();
            return false;
        }

        if (!FuncUtils.isPhone(mobile)) {
            ToastUtils.makeText(getActivity(), getActivity().getString(R.string.sh_phone_invalid), Toast.LENGTH_SHORT).show();
            return false;
        }
        return true;
    }

    public boolean verifyInputInfo(String mobile, String code) {
        if (!verifyInputMobileInfo(mobile)) {
            return false;
        }
        if (TextUtils.isEmpty(code)) {
            ToastUtils.makeText(getActivity(), getActivity().getString(R.string.sh_code_null), Toast.LENGTH_SHORT).show();
            return false;
        }
        return true;
    }

    private boolean verifyNetWorkState() {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return false;
        }
        return true;
    }


    public void showLoadingDialog() {
        loadingDialog.showLoading(R.string.sh_bind_person_loading);
    }

    public void dismissLoadingDialog() {
        loadingDialog.finishLoadingDialog();
    }

    public void showIdentifyDialog() {
        DialogRepository.showTwoBtnDialog(getActivity(), getActivity().getResources().getString(R.string.sh_not_in_table), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                toBindIdentify();
            }
        });
    }

    private MyCustomDialog singleDialog = null;

    public void showDialogAboutSingle() {
        if (singleDialog == null) {
            singleDialog = new MyCustomDialog.Builder(getActivity())
                    .setMessage(R.string.sh_single_error)
                    .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            dialogInterface.dismiss();
                        }
                    })
                    .create();
            singleDialog.setCancelable(false);
            singleDialog.setCanceledOnTouchOutside(false);
        }
        singleDialog.show();
    }

    /**
     * 跳转到绑定身份界面
     */
    private void toBindIdentify() {
        Intent intent = new Intent(getActivity(), BindIdentifyActivity.class);
        intent.putExtra(BindIdentifyActivity.TAG_PHONE, et_phone.getText().toString());
        getActivity().startActivity(intent);
        getActivity().finish();
    }

    /**
     * 展示弹框
     *
     * @param res
     */
    public void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog(getActivity(), getActivity().getString(res), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                getActivity().finish();
            }
        });
    }

    private InitFailDialog initFailDialog;

    public void showFailDialog() {
        if (initFailDialog == null) {
            initFailDialog = new InitFailDialog(getActivity());
            initFailDialog.setPositiveButton(new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            initFailDialog.setTimeInter(new InitFailDialog.TimeInter() {
                @Override
                public void timeOut() {
                    if (!verifyNetWorkState()) return;
                    showLoadingDialog();
                    initVhsm();
                }
            });
        }
        initFailDialog.show();
        initFailDialog.startTimer();
    }

    private void setPhoneLeftIcon(boolean hasInput) {
        if (hasInput) {
            ic_phone.setImageResource(R.drawable.sh_phone);
        } else {
            ic_phone.setImageResource(R.drawable.sh_phone_no_input);
        }
    }

    private void setVerifyCodeLeftIcon(boolean hasInput) {
        if (hasInput) {
            ic_verify_code.setImageResource(R.drawable.sh_verify_code);
        } else {
            ic_verify_code.setImageResource(R.drawable.sh_verify_code_no_input);
        }
    }


    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return VhsmInitView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_verify_mobile;
            }
        };
    }

}
