package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;

/**
 * 文件缺失， 管理员审批， 未申请或申请拒绝已显示
 * <p>
 * 都不显示，主动弹窗。
 * 安全助手暂不支持，只toast提示。
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class FileLostNoApplyHandle implements HandleMain {


    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        //服务端状态是正常或已就绪，
        //但本地状态是文件缺失，
        //同时审批方式是 短信审批，
        //同时申请状态是 未申请或申请拒绝已显示
        if (HandleUtils.isFileLost(vhsmBean) &&
                vhsmBean.verifyTypeBean != null &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                HandleUtils.isNotApplyOrShowedReject(vhsmBean.applyStatus.reInitApply)) {
            return true;
        }

        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        final Activity activity = view.getActivity();
        TextView tv_forgetPin = view.getTv_forgetPin();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_file_not_exists_tip);
        tv_forgetPin.setTextColor(activity.getResources().getColor(R.color.sh_modify_phone_text_color));

        int msg = R.string.sh_file_not_exist_dialog_msg;
        int btn_text = R.string.sh_submit_apply;
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setMessage(msg)
                .setPositiveButton(btn_text, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        //目前暂不支持
                        ToastUtils.makeText(activity, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();

        view.setShowingDialog(myCustomDialog);
    }

}
