package com.xdja.safehelper.activity.view.handle;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;

/**
 * 文件缺失， 管理员审批， 未审批
 * <p>
 * 按钮和状态显示。
 * 按钮点击，安全助手暂不支持，只toast提示。
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class FileLostNotApproveHandle implements HandleMain {


    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        //服务端状态是正常或已就绪，
        //但本地状态是文件缺失，
        //同时审批方式是 短信审批，
        //同时申请状态是 未申请或申请拒绝已显示
        if (HandleUtils.isFileLost(vhsmBean) &&
                vhsmBean.verifyTypeBean != null &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                vhsmBean.applyStatus.reInitApply == ApplyStatus.STATUS_NOT_APPROVAL) {
            return true;
        }

        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        final Context context = view.getActivity().getApplicationContext();
        TextView tvApplyStatus = view.getTv_apply_status();
        tvApplyStatus.setVisibility(View.VISIBLE);
        tvApplyStatus.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        tvApplyStatus.setTextColor(context.getResources().getColor(R.color.sh_single_btn_normal));
        tvApplyStatus.setText(R.string.sh_reinit_apply_submit);

        Button btnOperate = view.getBtn_operate();
        btnOperate.setVisibility(View.VISIBLE);
        btnOperate.setText(R.string.sh_reApply);
        btnOperate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //目前暂不支持
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });

        TextView tv_forgetPin = view.getTv_forgetPin();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_file_not_exists_tip);
        tv_forgetPin.setTextColor(context.getResources().getColor(R.color.sh_modify_phone_text_color));

    }

}
