package com.xdja.safehelper.activity.view.handle;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.net.bean.business.ApplyType;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;

/**
 * 文件缺失， 管理员审批， 已拒绝
 * <p>
 * 卡号不显示，不主动弹窗
 * 按钮 和 弹窗，安全助手暂不支持，只toast提示。
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class FileLostRejectHandle implements HandleMain {

    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        //服务端状态是正常或已就绪，
        //但本地状态是文件缺失，
        //同时审批方式是 短信审批，
        //同时申请状态是 未申请或申请拒绝已显示
        if (HandleUtils.isFileLost(vhsmBean) &&
                vhsmBean.verifyTypeBean != null &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                vhsmBean.applyStatus.reInitApply == ApplyStatus.STATUS_REGECT) {
            return true;
        }

        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        final Context context = view.getActivity().getApplicationContext();

        TextView tv_apply_status = view.getTv_apply_status();
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setTextColor(context.getResources().getColor(R.color.sh_deny_color));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);
        tv_apply_status.setText(R.string.sh_reinit_apply_deny);

        Button btn_operate = view.getBtn_operate();
        btn_operate.setVisibility(View.VISIBLE);
        btn_operate.setText(R.string.sh_reApply);
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });
        view.sendRejectRequest(ApplyType.TYPE_REINIT);
    }

}
