package com.xdja.safehelper.activity.view.handle;

import android.view.View;
import android.widget.TextView;

import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.vhsm.bean.VhsmBean;

/**
 * 网络异常处理
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class NetErrorHandle implements HandleMain {

    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.netStatus != 0) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(final VHSMMainViewNew view) {
        showNotFirst(view);
    }


    /**
     * 不是第一出现网络错误
     *
     * @param view
     */
    private void showNotFirst(final VHSMMainViewNew view) {
        view.hideViews();
        TextView tvApplyStatus = view.getTv_apply_status();
        tvApplyStatus.setVisibility(View.VISIBLE);
        tvApplyStatus.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.sh_refresh, 0);
        tvApplyStatus.setTextColor(view.getActivity().getResources().getColor(R.color.sh_modify_phone_text_color));
        tvApplyStatus.setText(R.string.sh_net_error);
        tvApplyStatus.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                view.doRefresh();
            }
        });
    }
}
