package com.xdja.safehelper.activity.view.handle;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * 正常，管理员审批模式，已同意
 * 卡号显示，
 * 状态不显示，
 * 按钮显示， 点击事件：重置PIN
 * 忘记PIN码显示， 点击 弹窗，弹窗点击事件 申请忘记PIN码（暂不支持）
 * 主动弹窗，弹窗点击事件： 重置PIN
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class NormalForgetPinAgreeHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (HandleUtils.isNormalOrReady(vhsmBean) &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_NORMAL &&
        vhsmBean.applyStatus.forgetPinApply == ApplyStatus.STATUS_AGREE) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(final VHSMMainViewNew view) {
        final Context context = view.getActivity().getApplicationContext();

        view.showCardId();

        view.getTv_apply_status().setVisibility(View.INVISIBLE);

        Button btn_operate = view.getBtn_operate();
        btn_operate.setVisibility(View.INVISIBLE);

        TextView tv_forgetPin = view.getTv_forgetPin();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(context.getString(R.string.sh_forget_pin_status,"已同意"));
        tv_forgetPin.setTextColor(context.getResources().getColor(R.color.sh_single_btn_normal));
        tv_forgetPin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });

    }
}
