package com.xdja.safehelper.activity.view.handle;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * 正常，管理员审批模式，未申请或拒绝已显
 * 卡号显示，
 * 状态不显示，
 * 按钮不显示，
 * 忘记PIN码显示，点击事件 申请忘记PIN码（暂不支持）
 * 不弹窗
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class NormalNotApplyHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (HandleUtils.isNormalOrReady(vhsmBean) &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_NORMAL &&
                HandleUtils.isNotApplyOrShowedReject(vhsmBean.applyStatus.forgetPinApply)) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        final Context context = view.getActivity().getApplicationContext();
        view.hideViews();
        view.showCardId();
        TextView tv_forgetPin = view.getTv_forgetPin();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_forget_pin);
        tv_forgetPin.setTextColor(context.getResources().getColor(R.color.sh_single_btn_normal));
        tv_forgetPin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });
    }
}
