package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * PIN码锁死，管理员审批，未申请或拒绝已显
 * <p>
 * 卡号显示
 * 状态显示，pin码已锁死
 * 按钮显示，点击 提交解锁申请
 * 忘记PIN码，不显示
 * 主动弹窗提示， 点击按钮 提交解锁申请
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class PinLockedNotApplyHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_LOCKED &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                (vhsmBean.applyStatus.unlockApply == ApplyStatus.STATUS_NOT_APPLY || vhsmBean.applyStatus.unlockApply == ApplyStatus.STATUS_REGECT_SHOWED)) {
            return true;
        }

        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        Activity activity = view.getActivity();
        final Context context = activity.getApplicationContext();

        view.showCardId();

        TextView tv_apply_status = view.getTv_apply_status();
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setText(R.string.sh_locked_dialog_msg);
        tv_apply_status.setTextColor(context.getResources().getColor(R.color.sh_deny_color));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);

        Button btn_operate = view.getBtn_operate();
        btn_operate.setText(R.string.sh_submit_apply);
        btn_operate.setVisibility(View.VISIBLE);
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });

        view.getTv_forgetPin().setVisibility(View.INVISIBLE);

        int msg = R.string.sh_locked_dialog_msg;
        int btn_text = R.string.sh_submit_apply;
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setMessage(msg)
                .setPositiveButton(btn_text, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
        view.setShowingDialog(myCustomDialog);
    }
}
