package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.net.bean.business.ApplyType;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * PIN码锁死，管理员审批，未审批
 * <p>
 * 卡号显示
 * 状态显示，pin码已锁死
 * 按钮显示，点击 提交解锁申请 (暂不支持)
 * 忘记PIN码，不显示
 * 弹窗不显示
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class PinLockedRejectHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_LOCKED &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                vhsmBean.applyStatus.unlockApply == ApplyStatus.STATUS_REGECT) {
            return true;
        }

        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        Activity activity = view.getActivity();
        final Context context = activity.getApplicationContext();

        view.showCardId();

        String msg = context.getString(R.string.sh_unlock_apply_deny);

        TextView tv_apply_status = view.getTv_apply_status();
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setText(msg);
        tv_apply_status.setTextColor(context.getResources().getColor(R.color.sh_deny_color));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);

        Button btn_operate = view.getBtn_operate();
        btn_operate.setText(R.string.sh_apply_again);
        btn_operate.setVisibility(View.VISIBLE);
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtils.makeText(context, R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
            }
        });

        view.getTv_forgetPin().setVisibility(View.INVISIBLE);

        view.sendRejectRequest(ApplyType.TYPE_UNLOCK);
    }
}
