package com.xdja.safehelper.module.deviceinfo;

import android.app.Activity;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.net.bean.business.ApplyType;
import com.xdja.initvhsm.net.bean.business.ReInitBean;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;

import io.reactivex.functions.Consumer;

/**
 * Created by hyh on 2020/4/14.
 */
public class ApplyResetInit {

    private Activity activity;

    private LoadingDialog loadingDialog;

    private BusinessRespAsync businessRespAsync;
    private NetRespositoryASync netRespositoryASync;


    private ResetInitCallback resetInitCallback;

    /**
     * 使用
     *
     * @param activity
     * @param loadingDialog
     * @param resetInitCallback
     */
    public ApplyResetInit(Activity activity, LoadingDialog loadingDialog, ResetInitCallback resetInitCallback) {
        this.activity = activity;
        this.loadingDialog = loadingDialog;
        businessRespAsync = new BusinessRespAsync();
        netRespositoryASync = new NetRespositoryASync();
        this.resetInitCallback = resetInitCallback;
    }

    public void applyReInit() {
        if (!NetUtils.isNetworkConnected(activity)) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(activity);
            return;
        }

        if (this.loadingDialog.isShowing()) {
            return;
        }

        this.loadingDialog.showLoading(R.string.sh_dev_reinit_apply_loading);
        businessRespAsync.reInitApply(new Consumer<ReInitBean>() {
            @Override
            public void accept(ReInitBean applyResult) throws Exception {
                loadingDialog.finishLoadingDialog();
                showReInitApplyStatus(applyResult.status);
            }
        });
    }


    private void showReInitApplyStatus(int status) {
        if (status == ReInitBean.STATUS_OK) {
            ToastUtils.makeText(activity, R.string.sh_reinit_apply_submit, Toast.LENGTH_SHORT).show();
            showBtnStatus( ApplyStatus.STATUS_NOT_APPROVAL);
        } else if (status == ReInitBean.STATUS_DEVICE_LOGOFF) {
            showNotifyDialog(R.string.sh_device_is_stopped);
        } else if (status == ReInitBean.STATUS_UNLOCK_NOT_COMPLETE) {
            ToastUtils.makeText(activity,
                    activity.getString(R.string.sh_unlock_apply_tobe_approval), Toast.LENGTH_SHORT).show();
        } else if (status == ReInitBean.STATUS_RESET_PIN_NOT_COMPLETE) {
            ToastUtils.makeText(activity,
                    activity.getString(R.string.sh_reset_apply_tobe_approval), Toast.LENGTH_SHORT).show();
        } else if (status == ReInitBean.STATUS_NOT_APPLY) {
            showDialogNotApply();
        } else if (status == ReInitBean.STATUS_REINIT_APPLY_FOR_APPROVAL) {
            showForApprovalDialog();
        } else if (status == ReInitBean.STATUS_REINIT_APPLY_AGREE) {
            showReInitApplyAgreeDialog();
        } else if (status == ReInitBean.STATUS_REINIT_APPLY_REJECT) {
            showRejectDialog();
        } else if (status == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(activity);
        } else if (status == ErrorCode.RET_COMPANY_DISABLE) {
            showNotifyDialog(R.string.sh_company_disable);
        } else {
            ToastUtils.makeText(activity, ErrorMatcher.getErrorMsg(status), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 展示被拒绝弹框
     */
    private void showRejectDialog() {
        DialogRepository.showNotifyDialog(activity, activity.getString(R.string.sh_reinit_apply_reject), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                sendRejectRequest();
                showBtnStatus( ApplyStatus.STATUS_NOT_APPLY);
                dialog.dismiss();
            }
        });
    }

    private void showForApprovalDialog() {
        String msg = "重新初始化";
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setMessage(activity.getString(R.string.sh_dev_apply_submit, msg))
                .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                })
                .setPositiveButton(R.string.sh_apply_again, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        reInitApply();
                    }
                }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 重新初始化申请 已同意
     */
    private void showReInitApplyAgreeDialog() {
        DialogRepository.showTextCenterHorizontalTwoBtnDialog(activity, activity.getString(R.string.sh_reInit_apply_agree_dialog_msg), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                reInit();
            }
        });
    }

    private void reInit() {

        if (!NetUtils.isNetworkConnected(activity)) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(activity);
            return;
        }

        if (loadingDialog.isShowing()) {
            return;
        }

        loadingDialog.showLoading(R.string.sh_dev_reinit_loading);
        businessRespAsync.reInit(new Consumer<Integer>() {
            @Override
            public void accept(Integer ret) throws Exception {
                loadingDialog.finishLoadingDialog();
                if (ret == 0) {
                    resetInitCallback.resetInitSuccess();
                    ToastUtils.makeText(activity, R.string.sh_dev_reinit_success, Toast.LENGTH_SHORT).show();
                } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
                    DialogRepository.showNetErrorDialog(activity);
                } else if (ret == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    ToastUtils.makeText(activity, ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }


    /**
     * 展示弹框
     *
     * @param res
     */
    private void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog(activity, activity.getString(res), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                activity.finish();
            }
        });
    }

    /**
     * 重新初始化申请
     */
    private void reInitApply() {
        if (!NetUtils.isNetworkConnected(activity)) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(activity);
            return;
        }
        if (loadingDialog.isShowing()) {
            return;
        }
        loadingDialog.showLoading(R.string.sh_dev_reinit_apply_loading);
        netRespositoryASync.reInitApply(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                loadingDialog.finishLoadingDialog();
                if (integer == 0) {
                    ToastUtils.makeText(activity, R.string.sh_reinit_apply_submit, Toast.LENGTH_SHORT).show();
                    showBtnStatus( ApplyStatus.STATUS_NOT_APPROVAL);
                } else if (integer == ErrorCode.RET_NET_EXCEPTION) {
                    DialogRepository.showNetErrorDialog(activity);
                } else if (integer == ErrorCode.RET_NET_DEVICE_DISABLE) {
                    showNotifyDialog(R.string.sh_device_is_stopped);
                } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    ToastUtils.makeText(activity, ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    /**
     * 未提交申请，弹框提示
     */
    private void showDialogNotApply() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setMessage(R.string.sh_reinit_to_apply)
                .setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        reInitApply();
                        dialog.dismiss();
                    }
                }).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        showBtnStatus(ApplyStatus.STATUS_NOT_APPLY);
                    }
                }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();

    }

    public void showBtnStatus(final int applyStatus) {
        Button applyStatusView = resetInitCallback.getApplyButton();
        if (applyStatusView == null) return;
        if (applyStatus == ApplyStatus.STATUS_AGREE) {
            applyStatusView.setText(activity.getString(R.string.sh_apply_reinit_status, "已同意"));
        } else if (applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {
            applyStatusView.setText(activity.getString(R.string.sh_apply_reinit_status, "待审批"));
        } else if (applyStatus == ApplyStatus.STATUS_REGECT) {
            applyStatusView.setText(activity.getString(R.string.sh_apply_reinit_status, "已拒绝"));
            sendRejectRequest();
        } else {
            applyStatusView.setText(R.string.sh_apply_reinit);
        }
        applyStatusView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                applyReInit();
            }
        });
    }

    /**
     * 拒绝状态回显
     */
    private void sendRejectRequest() {
        if (!NetUtils.isNetworkConnected(activity)) {
            return;
        }
        netRespositoryASync.sendRejectRequest(ApplyType.TYPE_REINIT, new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
            }
        });
    }

    public interface ResetInitCallback {
        void resetInitSuccess();

        Button getApplyButton();
    }
}
