package com.xdja.safehelper.module.vhsmbind;

import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VhsmInitView;


import com.xdja.safehelper.error.ErrorMatcher;

import com.xdja.safehelper.view.ToastUtils;

import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.safehelper.view.DialogRepository;

/**
 * Created by hyh on 2020/4/13.
 */
public class SHVhsmInitResultCallback implements ConsumerCallback<Integer> {
    private VhsmInitView vhsmInitView;

    public SHVhsmInitResultCallback(VhsmInitView vhsmInitView) {
        this.vhsmInitView = vhsmInitView;
    }

    private int num;


    @Override
    public void resultCallback(Integer ret) {
        if (vhsmInitView.getActivity().isFinishing() || vhsmInitView.getActivity().isDestroyed())
            return;
        vhsmInitView.dismissLoadingDialog();
        if (ret == 0) {
            ToastUtils.makeText(vhsmInitView.getActivity(), R.string.sh_dev_init_success, Toast.LENGTH_SHORT).show();
            vhsmInitView.getActivity().finish();
        } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(vhsmInitView.getActivity());
        } else if (ret == ErrorCode.RET_DEVICE_ACHIVE_MAX || ret == ErrorCode.RET_LICENSE_MAX_DEVICE) {
            ToastUtils.makeText(vhsmInitView.getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
        } else if (ret == ErrorCode.RET_COMPANY_DISABLE) {
            vhsmInitView.showNotifyDialog(R.string.sh_company_disable);
        } else {
            if (num == 0) {
                num++;
                vhsmInitView.showFailDialog();
            } else {
                ToastUtils.makeText(vhsmInitView.getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
            }
        }
    }
}
