package com.xdja.safehelper.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.LinearLayout;
import android.widget.TextView;


import com.xdja.safehelper.R;

import io.reactivex.annotations.Nullable;

public class CertItemView extends LinearLayout {
    public CertItemView(Context context) {
        super(context);
        initView(context);
    }

    public CertItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    private LinearLayout mContainer;
    private TextView tv_type, tv_container, tv_SN, tv_giver, tv_user, tv_valid;

    private void initView(Context context) {
        LayoutParams lp = new LayoutParams(
                LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mContainer = (LinearLayout) LayoutInflater.from(context).inflate(
                R.layout.sh_layout_cert_item, this,false);
        addView(mContainer, lp);
        tv_type = findViewById(R.id.tv_type);
        tv_container = findViewById(R.id.tv_container);
        tv_SN = findViewById(R.id.tv_SN);
        tv_giver = findViewById(R.id.tv_giver);
        tv_user = findViewById(R.id.tv_user);
        tv_valid = findViewById(R.id.tv_valid);
    }


    public CertItemView setCertType(String type) {
        tv_type.setText(type);
        return this;
    }

    public CertItemView setContainer(String container) {
        tv_container.setText(container);
        return this;
    }


    public CertItemView setSN(String sn) {
        tv_SN.setText(sn);
        return this;
    }


    public CertItemView setGiver(String giver) {
        tv_giver.setText(giver);
        return this;
    }

    public CertItemView setUser(String user) {
        tv_user.setText(user);
        return this;
    }

    public CertItemView setValidPeriod(String valid) {
        tv_valid.setText(valid);
        return this;
    }

}
