package com.xdja.safehelper.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import com.xdja.safehelper.R;


/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2019/5/7 20:02 <br/>
 */
public class DialogRepository {
    public static MyCustomDialog showNotifyDialog(Context context, String msg, DialogInterface.OnClickListener clickListener) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(context)
                .setMessage(msg)
                .setPositiveButton(R.string.sh_confirm, clickListener)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
        return myCustomDialog;
    }

    /**
     * 此Dialog文字居中展示
     *
     * @param context
     * @param msg
     * @param leftButtonListener
     * @param rightButtonListener
     */
    public static void showTwoBtnDialog(Context context, String msg,
                                        DialogInterface.OnClickListener leftButtonListener,
                                        DialogInterface.OnClickListener rightButtonListener) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(context)
                .setMessage(msg)
                .setNegativeButton(R.string.sh_cancel, leftButtonListener)
                .setPositiveButton(R.string.sh_confirm, rightButtonListener)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 此Dialog文字靠左对齐
     *
     * @param context
     * @param msg
     * @param leftButtonListener
     * @param rightButtonListener
     */
    public static void showTextCenterHorizontalTwoBtnDialog(Context context, String msg,
                                                            DialogInterface.OnClickListener leftButtonListener,
                                                            DialogInterface.OnClickListener rightButtonListener) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(context)
                .setMessage(msg)
                .setNegativeButton(R.string.sh_cancel, leftButtonListener)
                .setPositiveButton(R.string.sh_confirm, rightButtonListener)
                .setTextCenterHorizontal(false)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 展示弹框
     *
     * @param context
     * @param msg
     * @param negTitle
     * @param leftButtonListener
     * @param povTitle
     * @param rightButtonListener
     * @param isTextCenterHorizontal
     */
    public static void showDialogWithBtns(Context context, @StringRes int msg,
                                          @StringRes int negTitle,
                                          DialogInterface.OnClickListener leftButtonListener,
                                          @StringRes int povTitle,
                                          DialogInterface.OnClickListener rightButtonListener, boolean isTextCenterHorizontal) {
        MyCustomDialog.Builder builder = new MyCustomDialog.Builder(context).setMessage(msg);
        if (leftButtonListener != null) {
            builder.setNegativeButton(negTitle, leftButtonListener);
        }

        if (rightButtonListener != null) {
            builder.setNegativeButton(povTitle, rightButtonListener);
        }

        builder.setTextCenterHorizontal(false);
        MyCustomDialog myCustomDialog = builder.create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }


    /**
     * 网络异常弹框
     */
    public static MyCustomDialog showNetErrorDialog(Context context) {
        if (context instanceof Activity) {
            Activity activity = (Activity) context;
            if (activity.isFinishing() && activity.isDestroyed()) {
                return null;
            }
        }
        MyCustomDialog netErrorDialog = new MyCustomDialog.Builder(context)
                .setMessage(R.string.sh_net_error)
                .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                })
                .create();
        netErrorDialog.setCancelable(false);
        netErrorDialog.setCanceledOnTouchOutside(false);
        netErrorDialog.show();
        return netErrorDialog;
    }


}
