package com.xdja.safehelper.view;


import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;


import com.xdja.safehelper.R;
import com.xdja.vhsm.bean.IdentifyItem;

import java.util.List;


public class IdentifyAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {


    private List<IdentifyItem> identifyItems;

    public IdentifyAdapter(List<IdentifyItem> identifyItems) {
        this.identifyItems = identifyItems;
    }


    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.sh_layout_identify_item0, viewGroup, false);
        return new VH(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        ((VH) viewHolder).bindData(position);
    }


    @Override
    public int getItemCount() {
        if (identifyItems == null) {
            return 0;
        }
        return identifyItems.size();
    }


    private class VH extends RecyclerView.ViewHolder {
        private TextView tv_name, tv_content;
        private ImageView eye;


        public VH(@NonNull View itemView) {
            super(itemView);
            tv_name = itemView.findViewById(R.id.tv_name);
            tv_content = itemView.findViewById(R.id.tv_content);
            eye = itemView.findViewById(R.id.eye);
        }


        public void bindData(int pos) {
            IdentifyItem identifyItem = identifyItems.get(pos);
            tv_name.setText(identifyItem.key);

            if (identifyItem.key.equals(tv_name.getContext().getString(R.string.sh_bind_id))) {
                final String value = identifyItem.value;
                if (TextUtils.isEmpty(value)) {
                    return;
                }
                final String id = value.substring(0, 10) + "****" + value.substring(14, identifyItem.value.length());
                tv_content.setText(id);
                eye.setVisibility(View.VISIBLE);
                eye.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (tv_content.getText().toString().contains("*")) {
                            tv_content.setText(value);
                            eye.setImageResource(R.drawable.sh_close_eye);
                        } else {
                            tv_content.setText(id);
                            eye.setImageResource(R.drawable.sh_eye);
                        }
                    }
                });
            } else {
                tv_content.setText(identifyItem.value);
                eye.setVisibility(View.GONE);
            }

        }

    }


    /**
     * 初始化列表
     *
     * @param recyclerView
     */
    public void initRecyclerView(RecyclerView recyclerView, Context context) {
        LinearLayoutManager layoutManager = new LinearLayoutManager(recyclerView.getContext());
        recyclerView.setLayoutManager(layoutManager);
        layoutManager.setOrientation(OrientationHelper.VERTICAL);
        recyclerView.addItemDecoration(new SHItemDecoration(context, (int) context.getResources().getDimension(R.dimen.base_24)))
        ;
        recyclerView.setAdapter(this);
    }
}
