package com.xdja.safehelper.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;


import com.xdja.safehelper.R;

import java.util.Timer;
import java.util.TimerTask;

public class InitFailDialog extends SafeHelperCommonDialog {

    private Context context;

    public InitFailDialog(Context context) {
        super(context);
        this.context = context;
    }


    private TextView tv_content;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setCanceledOnTouchOutside(false);
    }

    @Override
    public int getLayoutId() {
        return R.layout.sh_dialog_init_fail;
    }

    @Override
    public void initView() {
        tv_content = findViewById(R.id.tv_content);
        tv_content.setText(getSpannableStringBuilder(3));


        Button btn_positive = findViewById(R.id.btn_positive);
        btn_positive.setText(R.string.sh_cancel_and_return);
        btn_positive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (positiveButtonClickListener != null) {
                    positiveButtonClickListener.onClick(InitFailDialog.this, BUTTON_POSITIVE);
                }
            }
        });
    }


    private OnClickListener positiveButtonClickListener;

    private TimeInter timeInter;


    public void setPositiveButton(OnClickListener onClickListener) {
        this.positiveButtonClickListener = onClickListener;

    }

    public void setTimeInter(TimeInter timeInter) {
        this.timeInter = timeInter;
    }


    private int time;
    private Timer timer;

    public void startTimer() {
        time = 3;
        TimerTask task = new TimerTask() {
            @Override
            public void run() {
                ((Activity) context).runOnUiThread(new Runnable() {        // UI thread
                    @Override
                    public void run() {
                        time--;
                        tv_content.setText(getSpannableStringBuilder(time));
                        if (time <= 0) {
                            cancelTimer();
                            dismiss();
                            if (timeInter != null) {
                                timeInter.timeOut();
                            }

                        }
                    }
                });
            }

        };
        timer = new Timer();
        timer.schedule(task, 1000, 1000);
    }


    /**
     * 取消倒计时
     */
    public void cancelTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }


    private SpannableStringBuilder getSpannableStringBuilder(int time) {
        SpannableStringBuilder style = new SpannableStringBuilder(context.getString(R.string.sh_init_fail_3, time));
        style.setSpan(new ForegroundColorSpan(Color.RED), 11, 13, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        return style;
    }

    /**
     * 倒计时结束时调用
     */
    public interface TimeInter {
        void timeOut();
    }

}
