package com.xdja.safehelper.view;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.safehelper.R;


/**
 * Created by guoyaxin on 2016/8/10.
 */
public class MyCustomDialog extends SafeHelperCommonDialog {

    private Builder builder;

    public MyCustomDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (builder.message != null || builder.msgStyle != null) {
            TextView tv_content = findViewById(R.id.tv_content);
            if (!builder.centerHorizontal) {
                tv_content.setGravity(Gravity.LEFT);
            }
            if (builder.message != null) {
                tv_content.setText(builder.message);
            }

            if (builder.msgStyle != null) {
                tv_content.setText(builder.msgStyle);
            }

        }

        if (builder.positiveButtonText != null) {
            Button btn_positive = findViewById(R.id.btn_positive);
            btn_positive.setText(builder.positiveButtonText);
            btn_positive.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    builder.positiveButtonClickListener.onClick(MyCustomDialog.this, BUTTON_POSITIVE);
                }
            });
        }

        if (builder.negativeButtonText != null) {
            Button btn_negative = findViewById(R.id.btn_negative);
            btn_negative.setText(builder.negativeButtonText);
            btn_negative.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    builder.negativeButtonClickListener.onClick(MyCustomDialog.this, BUTTON_NEGATIVE);
                }
            });
        }
    }

    private void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Override
    public int getLayoutId() {
        if (TextUtils.isEmpty(builder.negativeButtonText)) {
            return R.layout.sh_new_dialog_with_singlebtn;
        } else {
            return R.layout.sh_new_dialog;
        }
    }

    public static class Builder {

        private Context context;
        private String message;
        private SpannableStringBuilder msgStyle;
        private String positiveButtonText;
        private String negativeButtonText;
        private OnClickListener positiveButtonClickListener;
        private OnClickListener negativeButtonClickListener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setSpannableMessage(SpannableStringBuilder style) {
            msgStyle = style;
            return this;
        }


        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            this.message = context.getString(message);
            return this;
        }


        public Builder setPositiveButton(String positiveButtonText, OnClickListener onClickListener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText, OnClickListener onClickListener) {
            this.positiveButtonText = context.getString(positiveButtonText);
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, OnClickListener onClickListener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButtonText, OnClickListener onClickListener) {
            this.negativeButtonText = context.getString(negativeButtonText);
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        private boolean centerHorizontal = true;

        public Builder setTextCenterHorizontal(boolean centerHorizontal) {
            this.centerHorizontal = centerHorizontal;
            return this;
        }


        public MyCustomDialog create() {
            final MyCustomDialog dialog = new MyCustomDialog(context);
            dialog.setBuilder(this);
            return dialog;
        }


    }

}
