package com.xdja.safehelper.view;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;


import com.xdja.safehelper.R;
import com.xdja.vhsm.bean.CheckItemInfo;

import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/6/12 <br/>
 */
public class SelfCheckAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private ArrayList<CheckItemInfo> infoList = new ArrayList<>();

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.sh_layout_self_check_item, viewGroup, false);
        return new SelfCheckViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        ((SelfCheckViewHolder) viewHolder).bindData(infoList.get(position));
    }

    public void addInfo(CheckItemInfo info) {
        infoList.add(info);
        notifyDataSetChanged();
    }

    public void clear() {
        infoList.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return infoList.size();
    }

    class SelfCheckViewHolder extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView textMsg;

        public SelfCheckViewHolder(@NonNull View itemView) {
            super(itemView);
            imageView = itemView.findViewById(R.id.image_icon);
            textMsg = itemView.findViewById(R.id.text_msg);
        }

        public void bindData(CheckItemInfo info) {
            if (info.ret == 0) {
                imageView.setImageResource(R.drawable.sh_image_ok);
            } else {
                imageView.setImageResource(R.drawable.sh_image_not_ok);
            }
            textMsg.setText(info.msg);
        }
    }
}
