package com.xdja.safehelper.view;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;


import com.xdja.safehelper.R;
import com.xdja.safehelper.update.SHUpdateManager;
import com.xdja.vhsm.bean.SettingItemInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/8/5 <br/>
 */
public class SettingAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private ArrayList<SettingItemInfo> infoList = new ArrayList<>();

    public void addInfo(SettingItemInfo info) {
        infoList.add(info);
        notifyDataSetChanged();
    }

    public void addInfo(List<SettingItemInfo> info) {
        infoList.clear();
        infoList.addAll(info);
        notifyDataSetChanged();
    }

    public void clear() {
        infoList.clear();
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.sh_list_setting_single, viewGroup, false);
        return new SettingItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        if (infoList != null) {
            SettingItemInfo item = infoList.get(i);
            if (item != null) {
                ((SettingItemViewHolder) viewHolder).bindData(item);
            }
        }
    }

    @Override
    public int getItemCount() {
        return infoList.size();
    }

    class SettingItemViewHolder extends RecyclerView.ViewHolder {
        TextView textInfo;
        private View itemView;

        ImageView imageView;

        View upgradeRemindView;

        public SettingItemViewHolder(@NonNull View itemView) {
            super(itemView);
            textInfo = itemView.findViewById(R.id.text_info);
            imageView = itemView.findViewById(R.id.iv_item_setting);
            upgradeRemindView = itemView.findViewById(R.id.upgrade_remid);
            this.itemView = itemView;
        }

        public void bindData(SettingItemInfo info) {
            textInfo.setText(info.info);
            if (info.iconRes != 0) {
                imageView.setVisibility(View.VISIBLE);
                imageView.setImageResource(info.iconRes);
            } else {
                imageView.setVisibility(View.GONE);
            }
            if (info.listener != null) {
                itemView.setOnClickListener(info.listener);
            }
            upgradeRemindView.setVisibility(View.GONE);
            try {
                if (info.info.equals(itemView.getContext().getString(R.string.sh_setting_check_new))) {
                    if (SHUpdateManager.getInstance().hasNewVersion) {
                        upgradeRemindView.setVisibility(View.VISIBLE);
                    }
                }
            } catch (Exception e) {

            }
        }
    }
}
