package com.xdja.safehelper.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.safehelper.R;

/**
 * Created by hyh on 2020/4/21.
 */
public class ToastUtils {

    public static Toast makeText(Context context, int resId, int duration) {
        return makeText(context, context.getResources().getString(resId), duration);
    }

    public static Toast makeText(Context context, String mag, int duration) {
        Toast toast = new Toast(context);
        toast.setView(getToastContentView(context, mag));
        toast.setDuration(duration);
        return toast;
    }

    private static View getToastContentView(Context context, String msg) {
        View view = LayoutInflater.from(context).inflate(R.layout.sh_toast_layout, null);
        TextView textView = view.findViewById(R.id.tv_msg);
        textView.setText(msg);
        return view;
    }
}
