/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.KeyEvent;
import android.widget.TextView;
import com.xdja.safehelper.ActivityStackManager;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.utils.ViewUtils;

public class BaseActivity
extends Activity {
    protected String tag = "VHSM_Init";
    private LoadingDialog loadingDialog;
    protected Toolbar toolbar;
    private TextView left_title_tv;
    private MyCustomDialog netErrorDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getResources().getConfiguration().orientation == 2) {
            this.setRequestedOrientation(1);
        }
        ActivityStackManager.getInstance().add(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.finishLoadingDialog();
        ActivityStackManager.getInstance().remove(this);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.handleKeyBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void initToolbar(boolean isShowBackIcon, int title) {
    }

    public void handleKeyBack() {
        if (ViewUtils.isKeyboardShown((Context)this)) {
            ViewUtils.hideInputWindowDelay((Context)this);
        } else {
            this.finish();
        }
    }

    public void showLoadingDialog(int msgId) {
        if (this.loadingDialog == null) {
            this.loadingDialog = new LoadingDialog((Context)this);
        }
        if (!this.isShowDialog() && !this.isFinishing()) {
            this.loadingDialog.setContent(this.getString(msgId));
            this.loadingDialog.show();
        }
    }

    public void finishLoadingDialog() {
        if (this.isShowDialog()) {
            try {
                this.loadingDialog.dismiss();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowDialog() {
        if (this.loadingDialog == null) {
            return false;
        }
        return this.loadingDialog.isShowing();
    }

    public void showNetErrorDialog() {
        if (this.netErrorDialog == null) {
            this.netErrorDialog = new MyCustomDialog.Builder((Context)this).setMessage(R.string.sh_net_error).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                }
            }).create();
            this.netErrorDialog.setCancelable(false);
            this.netErrorDialog.setCanceledOnTouchOutside(false);
        }
        if (this.isFinishing()) {
            return;
        }
        this.netErrorDialog.show();
    }

    private void showDialogAboutSingle() {
        if (this.netErrorDialog == null) {
            this.netErrorDialog = new MyCustomDialog.Builder((Context)this).setMessage(R.string.sh_net_error).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                }
            }).create();
            this.netErrorDialog.setCancelable(false);
            this.netErrorDialog.setCanceledOnTouchOutside(false);
        }
        if (this.isFinishing()) {
            return;
        }
        this.netErrorDialog.show();
    }
}

