/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.xdja.initvhsm.net.bean.PersonInfo;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BaseActivity;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import io.reactivex.functions.Consumer;

public class BindIdentifyActivity
extends BaseActivity {
    private NetRespositoryASync netRespositoryASync;
    public static String TAG_PHONE = "tag_phone";
    private String phone;
    private EditText et_name;
    private EditText et_phone;
    private EditText et_ip;
    private EditText et_union;
    private Button btn_operate;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sh_layout_bind_identity);
        this.initView();
    }

    private void initView() {
        this.initToolbar(true, R.string.sh_regist_apply);
        this.et_name = (EditText)this.findViewById(R.id.et_name);
        this.et_phone = (EditText)this.findViewById(R.id.et_phone);
        this.et_ip = (EditText)this.findViewById(R.id.et_ip);
        this.et_union = (EditText)this.findViewById(R.id.et_union);
        this.btn_operate = (Button)this.findViewById(R.id.btn_operate);
        this.phone = this.getIntent().getStringExtra(TAG_PHONE);
        this.et_phone.setText((CharSequence)this.phone);
        this.btn_operate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BindIdentifyActivity.this.showSubmitDialog();
            }
        });
        this.netRespositoryASync = new NetRespositoryASync();
    }

    private void showSubmitDialog() {
        String name = this.et_name.getText().toString();
        String phone = this.et_phone.getText().toString();
        String id2 = this.et_ip.getText().toString();
        String union = this.et_union.getText().toString();
        if (TextUtils.isEmpty((CharSequence)name)) {
            ToastUtils.makeText((Context)this, this.getString(R.string.sh_name_and_phone_null, new Object[]{"\u59d3\u540d"}), 0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)phone)) {
            ToastUtils.makeText((Context)this, this.getString(R.string.sh_name_and_phone_null, new Object[]{"\u624b\u673a\u53f7"}), 0).show();
            return;
        }
        if (!FuncUtils.isPhone((String)phone)) {
            ToastUtils.makeText((Context)this, this.getString(R.string.sh_phone_invalid), 0).show();
            return;
        }
        String subDes = this.getString(R.string.sh_bind_submit, new Object[]{name, phone, id2, union, phone});
        DialogRepository.showTextCenterHorizontalTwoBtnDialog((Context)this, subDes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BindIdentifyActivity.this.submit();
            }
        });
    }

    private void submit() {
        String str;
        String name = this.et_name.getText().toString();
        String phone = this.et_phone.getText().toString();
        String ip = this.et_ip.getText().toString();
        String union = this.et_union.getText().toString();
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)phone)) {
            ToastUtils.makeText((Context)this, this.getString(R.string.sh_name_and_phone_null), 0).show();
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)ip) && !(str = FuncUtils.isIdentifier((String)ip)).equals("yes")) {
            ToastUtils.makeText((Context)this, str, 0).show();
            return;
        }
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        PersonInfo personInfo = new PersonInfo();
        personInfo.name = name;
        personInfo.identity = ip;
        personInfo.mobile = phone;
        personInfo.deptName = union;
        this.netRespositoryASync.registPersonInfo(personInfo, (Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                BindIdentifyActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    BindIdentifyActivity.this.finish();
                } else if (integer == -10005) {
                    BindIdentifyActivity.this.showNetErrorDialog();
                } else if (integer == -33) {
                    ToastUtils.makeText((Context)BindIdentifyActivity.this, R.string.sh_dev_reg_already_exist, 0).show();
                } else {
                    ToastUtils.makeText((Context)BindIdentifyActivity.this, ErrorMatcher.getErrorMsg(integer), 0).show();
                }
            }
        });
    }
}

