/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BaseActivity;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.utils.FuncUtils;
import io.reactivex.functions.Consumer;

public class ForAdaptOldVhsmActivity
extends BaseActivity {
    private BusinessRespAsync businessRespAsync;
    private Button btnOk;
    private EditText editIdentify;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sh_activity_for_adapt_old_vhsm);
        this.initView();
    }

    private void initView() {
        this.initToolbar(true, R.string.sh_for_adapt_old_vhsm_title);
        this.btnOk = (Button)this.findViewById(R.id.btn_ok);
        this.btnOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ForAdaptOldVhsmActivity.this.btnOkClick();
            }
        });
        this.editIdentify = (EditText)this.findViewById(R.id.edit_identify);
        this.editIdentify.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s == null || s.length() == 0) {
                    ForAdaptOldVhsmActivity.this.btnOk.setEnabled(false);
                } else {
                    ForAdaptOldVhsmActivity.this.btnOk.setEnabled(true);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.businessRespAsync = new BusinessRespAsync();
    }

    private void btnOkClick() {
        String identify = this.editIdentify.getText().toString();
        if (TextUtils.isEmpty((CharSequence)identify)) {
            ToastUtils.makeText((Context)this, R.string.sh_bind_id, 0).show();
            return;
        }
        this.showLoadingDialog(R.string.sh_verify_identify_loading);
        this.businessRespAsync.getImeisAndVerify(FuncUtils.getDevId((Context)this), identify, (Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                if (integer == 0) {
                    ForAdaptOldVhsmActivity.this.showLockedDialog(R.string.sh_verify_identity_success);
                } else if (integer == -34) {
                    ToastUtils.makeText((Context)ForAdaptOldVhsmActivity.this, R.string.sh_identity_not_in_system, 0).show();
                } else {
                    ForAdaptOldVhsmActivity.this.showLockedDialog(R.string.sh_verify_identity_fail);
                }
            }
        });
    }

    private void showLockedDialog(final @StringRes int strRes) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(strRes).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (strRes == R.string.sh_verify_identity_success) {
                    ForAdaptOldVhsmActivity.this.finish();
                }
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }
}

