/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputEditText;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BaseActivity;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.domain.ServerConfigRepository;
import com.xdja.vhsm.permission.OnPermissionListener;
import com.xdja.vhsm.permission.SPermission;
import com.xdja.vhsm.utils.AssetsConfigUtils;
import com.xdja.vhsm.utils.ConfigUtils;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.vhsm.utils.ViewUtils;
import io.reactivex.functions.Consumer;
import java.util.Timer;
import java.util.TimerTask;

public class ServerConfigActivity
extends BaseActivity {
    private TextInputEditText editText_ip;
    private TextInputEditText editText_port;
    private TextInputEditText editText_Address;
    private TextInputEditText editText_Address_port;
    private LinearLayout layoutIpPort;
    private LinearLayout layoutAddress;
    private Button btn_connect;
    Button btnSetting;
    private AlertDialog commonDialog;
    private boolean isShowIp = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sh_activity_server_config);
        this.initView();
        this.initData();
    }

    public void onResume() {
        super.onResume();
        Log.d((String)this.tag, (String)"onResume");
        if (this.isGrantedPermission()) {
            ViewUtils.showInputWindowDelay((Activity)this);
        } else {
            try {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ServerConfigActivity.this.requestPermission();
                    }
                }, 300L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onPause() {
        super.onPause();
        ViewUtils.hideInputWindowDelay((Context)this);
        SPermission sPermission = SPermission.getsPermission();
        if (sPermission != null) {
            sPermission.activeSPermission();
        }
    }

    private void initView() {
        this.initToolbar();
        this.layoutIpPort = (LinearLayout)this.findViewById(R.id.layout_ip_port);
        this.layoutAddress = (LinearLayout)this.findViewById(R.id.layout_address);
        this.editText_ip = (TextInputEditText)this.findViewById(R.id.edit_init_ip);
        this.editText_ip.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus) {
                    // empty if block
                }
            }
        });
        this.editText_port = (TextInputEditText)this.findViewById(R.id.edit_init_port);
        this.editText_port.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus) {
                    ServerConfigActivity.this.validatePort(ServerConfigActivity.this.editText_port.getText().toString());
                }
            }
        });
        this.editText_Address = (TextInputEditText)this.findViewById(R.id.edit_init_address);
        this.editText_Address_port = (TextInputEditText)this.findViewById(R.id.edit_init_address_port);
        this.btn_connect = (Button)this.findViewById(R.id.btn_connect_config);
        this.btn_connect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ServerConfigActivity.this.onConnectClick();
            }
        });
    }

    private void initToolbar() {
        this.initToolbar(true, R.string.sh_setting_address_config);
        this.btnSetting = (Button)this.findViewById(R.id.btn_setting);
        this.btnSetting.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ServerConfigActivity.this.layoutConfigClick();
            }
        });
    }

    private void initData() {
        String ip = this.getIp();
        int port = this.getPort();
        String address = this.getAddress();
        int addressPort = this.getAddressPort();
        String type = ConfigUtils.getType((Context)this.getApplicationContext());
        this.editText_Address.setText((CharSequence)address);
        if (addressPort > 0) {
            this.editText_Address_port.setText((CharSequence)("" + addressPort));
        }
        if (!TextUtils.isEmpty((CharSequence)ip) && port > 0) {
            this.editText_ip.setText((CharSequence)ip);
            this.editText_ip.setSelection(ip.length());
            this.editText_port.setText((CharSequence)String.valueOf(port));
        }
        if (TextUtils.isEmpty((CharSequence)type)) {
            if (!TextUtils.isEmpty((CharSequence)ip)) {
                this.showIpAndPort();
            } else if (!TextUtils.isEmpty((CharSequence)address)) {
                this.showAddress();
            } else {
                this.showIpAndPort();
            }
        } else if ("initIp".equals(type)) {
            this.showIpAndPort();
        } else {
            this.showAddress();
        }
    }

    private String getIp() {
        String ip = ConfigUtils.getIP((Context)this.getApplicationContext());
        if (TextUtils.isEmpty((CharSequence)ip)) {
            ip = AssetsConfigUtils.getInstance().getServerIp();
        }
        return ip;
    }

    private int getPort() {
        int port = ConfigUtils.getPort((Context)this.getApplicationContext());
        if (port <= 0) {
            port = AssetsConfigUtils.getInstance().getServerIpPort();
        }
        return port;
    }

    private String getAddress() {
        String address = ConfigUtils.getAddress((Context)this.getApplicationContext());
        if (TextUtils.isEmpty((CharSequence)address)) {
            address = AssetsConfigUtils.getInstance().getServerAddress();
        }
        return address;
    }

    private int getAddressPort() {
        int addressPort = ConfigUtils.getAddressPort((Context)this.getApplicationContext());
        if (addressPort <= 0) {
            addressPort = AssetsConfigUtils.getInstance().getServerAddressPort();
        }
        return addressPort;
    }

    private void onConnectClick() {
        ViewUtils.hideInputWindowDelay((Context)this);
        if (this.layoutAddress.getVisibility() == 0) {
            this.saveAddressPort();
        } else {
            this.saveIpAndPort();
        }
    }

    private void saveIpAndPort() {
        String ip = this.editText_ip.getText().toString();
        String port = this.editText_port.getText().toString();
        if (this.validateIP(ip) && this.validatePort(port)) {
            this.saveConfig(ip, port, "");
        } else {
            ToastUtils.makeText((Context)this, R.string.sh_server_config_invalid, 0).show();
        }
    }

    private void saveAddressPort() {
        String address = this.editText_Address.getText().toString();
        String port = this.editText_Address_port.getText().toString();
        if (this.validateAddress(address) && this.validatePort(port)) {
            this.saveConfig("", port, address);
        } else {
            ToastUtils.makeText((Context)this, R.string.sh_server_config_invalid, 0).show();
        }
    }

    private void saveConfig(String ip, String port, String address) {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_server_config_saving);
        new ServerConfigRepository().saveServerConfigAsync((Context)this, ip, Integer.valueOf(port).intValue(), address, (Consumer)new Consumer<Integer>(){

            public void accept(Integer ret) throws Exception {
                ServerConfigActivity.this.finishLoadingDialog();
                if (ret == -10005) {
                    ServerConfigActivity.this.showNetErrorDialog();
                    return;
                }
                if (ret != 0) {
                    Log.e((String)"VhsmInit", (String)("saveServerConfigAsync ret: " + ret));
                    String errMsg = ServerConfigActivity.this.getString(R.string.sh_server_config_save_fail, new Object[]{ret});
                    if (ret == -1) {
                        errMsg = ServerConfigActivity.this.getString(R.string.sh_server_config_error);
                    }
                    ToastUtils.makeText((Context)ServerConfigActivity.this, errMsg, 0).show();
                    return;
                }
                ToastUtils.makeText((Context)ServerConfigActivity.this, R.string.sh_server_config_save_success, 0).show();
                ServerConfigActivity.this.handleKeyBack();
                ServerConfigActivity.this.finish();
            }
        });
    }

    private boolean validatePort(String portStr) {
        if (TextUtils.isEmpty((CharSequence)portStr)) {
            this.showError(this.editText_port, "\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        int port = -1;
        try {
            port = Integer.valueOf(portStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (port <= 0 || port > 65535) {
            this.showError(this.editText_port, "\u7aef\u53e3\u4e0d\u7b26\u5408\u8981\u6c42");
            return false;
        }
        return true;
    }

    private boolean validateIP(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            this.showError(this.editText_ip, "ip\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!FuncUtils.isValidIP((String)ip)) {
            this.showError(this.editText_ip, "ip\u5730\u5740\u4e0d\u7b26\u5408\u8981\u6c42");
            return false;
        }
        return true;
    }

    private boolean validateAddress(String address) {
        if (TextUtils.isEmpty((CharSequence)address)) {
            this.showError(this.editText_Address, "\u57df\u540d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (address.toLowerCase().startsWith("http://")) {
            this.showError(this.editText_Address, "\u8bf7\u5220\u9664http://");
            return false;
        }
        if (address.toLowerCase().startsWith("https://")) {
            this.showError(this.editText_Address, "\u8bf7\u5220\u9664https://");
            return false;
        }
        return true;
    }

    private void showError(TextInputEditText textInputLayout, String error) {
        textInputLayout.setError((CharSequence)error);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        SPermission.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
        Log.d((String)this.tag, (String)("onRequestPermissionsResult:" + requestCode));
    }

    private void requestPermission() {
        Log.d((String)this.tag, (String)"requestPermission");
        SPermission.with((Context)this).setMOUDLE(2).setmRequestCode(2).setPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}).setmOnPermissionListener(new OnPermissionListener(){

            public void onPermissionGranted() {
            }

            public void onPermissionDenied(String[] strings) {
                Log.d((String)ServerConfigActivity.this.tag, (String)"onPermissionDenied");
                ServerConfigActivity.this.createCommonDialog(R.string.sh_getDevId_some_powers_has_forbid, R.string.sh_WRITE_EXTERNAL_STORAGE_has_forbid_content, R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ServerConfigActivity.this.commonDialog.dismiss();
                        ServerConfigActivity.this.finish();
                    }
                }, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ServerConfigActivity.this.commonDialog.dismiss();
                        SPermission.getsPermission().activeSPermission();
                        ServerConfigActivity.this.requestPermission();
                    }
                });
            }

            public void onPermissionDeniedAlways(String[] strings) {
                Log.d((String)ServerConfigActivity.this.tag, (String)"onPermissionDeniedAlways");
                ServerConfigActivity.this.createCommonDialog(R.string.sh_acu_can_not_open_power_title, R.string.sh_acu_can_not_open_power_content, R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ServerConfigActivity.this.commonDialog.dismiss();
                        ServerConfigActivity.this.finish();
                    }
                }, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ServerConfigActivity.this.commonDialog.dismiss();
                        FuncUtils.getAppDetailSettingIntent((Context)ServerConfigActivity.this);
                    }
                });
            }
        }).requestPermissions();
    }

    private boolean isGrantedPermission() {
        return ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void createCommonDialog(int titleRes, int contentRes, int leftButtonRes, int rightButtonRes, DialogInterface.OnClickListener leftButtonListener, DialogInterface.OnClickListener rightButtonListener) {
        this.commonDialog = new AlertDialog.Builder((Context)this).setTitle(titleRes).setMessage(contentRes).setPositiveButton(rightButtonRes, rightButtonListener).setNegativeButton(leftButtonRes, leftButtonListener).create();
        this.commonDialog.setCanceledOnTouchOutside(false);
        this.commonDialog.setCancelable(false);
        this.commonDialog.show();
    }

    private void layoutConfigClick() {
        if (this.isShowIp) {
            this.showAddress();
        } else {
            this.showIpAndPort();
        }
    }

    private void showIpAndPort() {
        this.isShowIp = true;
        this.layoutIpPort.setVisibility(0);
        this.layoutAddress.setVisibility(8);
        this.btnSetting.setText(R.string.sh_lable_address);
    }

    private void showAddress() {
        this.isShowIp = false;
        this.layoutIpPort.setVisibility(8);
        this.layoutAddress.setVisibility(0);
        this.btnSetting.setText(R.string.sh_lable_ip);
        String strInEdit = this.editText_Address.getText().toString();
        if (TextUtils.isEmpty((CharSequence)strInEdit)) {
            this.editText_Address.setText((CharSequence)AssetsConfigUtils.getInstance().getServerAddress());
        }
    }
}

