/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.initvhsm.net.bean.business.ApplyResult;
import com.xdja.initvhsm.net.bean.business.ResetApplyBean;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BaseActivity;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.SettingActivity;
import com.xdja.safehelper.activity.VhsmBindActivity;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.update.Update;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.InitFailDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.VhsmManager;
import com.xdja.vhsm.domain.VHSMBean;
import com.xdja.vhsm.mvp.presenter.VhsmInitPresenter;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.permission.OnPermissionListener;
import com.xdja.vhsm.permission.SPermission;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;

public class VHSMMainActivity
extends BaseActivity {
    private BusinessRespAsync businessRespAsync;
    private NetRespositoryASync netRespositoryASync;
    private boolean isFirst;
    private View tv_refresh;
    private View img_setting;
    private TextView tv_cardId;
    private TextView tv_apply_status;
    private TextView tv_forgetPin;
    private Button btn_operate;
    private MyCustomDialog android10Dialog;
    private int num;
    private InitFailDialog initFailDialog;
    private AlertDialog commonDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sh_vhsm_main);
        this.businessRespAsync = new BusinessRespAsync();
        this.netRespositoryASync = new NetRespositoryASync();
        this.isFirst = true;
        this.initView();
    }

    private void initView() {
        this.initToolbar(false, R.string.sh_vhsm_manager);
        this.tv_refresh = this.findViewById(R.id.tv_refresh);
        this.tv_refresh.setVisibility(0);
        this.tv_refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VHSMMainActivity.this.requestPermissions();
            }
        });
        this.img_setting = this.findViewById(R.id.tar_img_setting);
        this.img_setting.setVisibility(0);
        this.img_setting.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VHSMMainActivity.this.gotoSetting();
            }
        });
        this.tv_cardId = (TextView)this.findViewById(R.id.tv_cardId);
        this.tv_apply_status = (TextView)this.findViewById(R.id.tv_apply_status);
        this.btn_operate = (Button)this.findViewById(R.id.btn_operate);
        this.tv_forgetPin = (TextView)this.findViewById(R.id.tv_forgetPin);
        this.hideViews();
    }

    private void hideViews() {
        this.tv_apply_status.setVisibility(8);
        this.btn_operate.setVisibility(8);
        this.tv_forgetPin.setVisibility(8);
    }

    private void gotoSetting() {
        this.startActivity(new Intent((Context)this, SettingActivity.class));
    }

    private void doRefresh() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            if (this.isFirst) {
                this.showNetError();
                this.isFirst = false;
            } else {
                this.showNetErrorDialog();
            }
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_device_status_loading);
        this.queryVHSMState();
    }

    protected void onResume() {
        super.onResume();
        this.requestPermissions();
    }

    protected void onPause() {
        super.onPause();
        SPermission.getsPermission().activeSPermission();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        SPermission.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
        Log.d((String)this.tag, (String)("onRequestPermissionsResult:" + requestCode));
    }

    private void queryVHSMState() {
        this.businessRespAsync.queryVHSMState((Consumer)new Consumer<VHSMBean>(){

            public void accept(VHSMBean vhsmBean) throws Exception {
                VHSMMainActivity.this.showVHSMStatus(vhsmBean);
            }
        });
    }

    private void showAndroid10Dialog() {
        if (this.android10Dialog == null) {
            String androidId = NetVhsmDeviceIdUtils.getAndroidID((Context)this);
            String android10tip = this.getString(R.string.sh_android10_tip, new Object[]{androidId});
            SpannableStringBuilder style2 = new SpannableStringBuilder((CharSequence)android10tip);
            style2.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.sh_value_color)), android10tip.lastIndexOf("\u3002") + 1, android10tip.length(), 34);
            this.android10Dialog = new MyCustomDialog.Builder((Context)this).setSpannableMessage(style2).setTextCenterHorizontal(false).setPositiveButton(R.string.sh_reinit, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    VHSMMainActivity.this.gotoVerifyPhone("");
                }
            }).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    VHSMMainActivity.this.finish();
                }
            }).create();
            this.android10Dialog.setCancelable(false);
            this.android10Dialog.setCanceledOnTouchOutside(false);
        }
        if (this.android10Dialog.isShowing()) {
            // empty if block
        }
        this.android10Dialog.show();
    }

    private void showVhsmOpenErrorDialog(int ret) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(this.getString(R.string.sh_android10_parse_error, new Object[]{ret})).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.finish();
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void showNetError() {
        this.hideViews();
        this.tv_apply_status.setVisibility(0);
        this.tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.tv_apply_status.setTextColor(this.getResources().getColor(R.color.sh_modify_phone_text_color));
        SpannableString spannableString = new SpannableString((CharSequence)this.getString(R.string.sh_net_error1));
        spannableString.setSpan((Object)new RelativeSizeSpan(1.0f), 0, 13, 17);
        spannableString.setSpan((Object)new RelativeSizeSpan(0.8f), 13, spannableString.length(), 17);
        this.tv_apply_status.setText((CharSequence)spannableString);
    }

    private void showVHSMStatus(VHSMBean vhsmBean) {
        this.finishLoadingDialog();
        if (vhsmBean.vhsmStatus == -10005) {
            if (this.isFirst) {
                this.showNetError();
                this.isFirst = false;
            } else {
                this.showNetErrorDialog();
            }
            return;
        }
        switch (vhsmBean.vhsmStatus) {
            case -9: {
                this.showNotifyDialog(R.string.sh_device_id_gibberish);
                break;
            }
            case -4: {
                this.showNotifyDialog(R.string.sh_device_is_stopped);
                break;
            }
            case -3: {
                this.showNotifyDialog(R.string.sh_device_is_logoff);
                break;
            }
            case -2: {
                this.showNotifyDialog(R.string.sh_device_is_invalid);
                break;
            }
            case -41: {
                this.showNotifyDialog(R.string.sh_company_disable);
                break;
            }
            case 0: {
                this.showViewVhsmOK();
                break;
            }
            case -6: 
            case -5: 
            case -1: 
            case 1: {
                this.showViewStatus(vhsmBean);
                break;
            }
            case -7: {
                this.showViewResetPin(vhsmBean);
                break;
            }
            case -8: {
                this.showAndroid10Dialog();
                break;
            }
            default: {
                if (vhsmBean.isOpenVHSMError) {
                    this.showVhsmOpenErrorDialog(vhsmBean.vhsmStatus);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)ErrorMatcher.getErrorMsg(vhsmBean.vhsmStatus), (int)0).show();
            }
        }
        Update.getInstance().checkUpdate(this, false);
    }

    private void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog((Context)this, this.getString(res), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.finish();
            }
        });
    }

    private void showNotInitialView(final int vhsmStatus) {
        this.hideViews();
        this.showVHSM();
        this.btn_operate.setVisibility(0);
        this.btn_operate.setText(R.string.sh_to_use);
        this.btn_operate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VHSMMainActivity.this.toUse(vhsmStatus);
            }
        });
    }

    private void showViewResetPin(VHSMBean bean) {
        this.showViewVhsmOK();
        if (bean.applyStatus == 1) {
            this.tv_forgetPin.setText((CharSequence)this.getString(R.string.sh_forget_pin_status, new Object[]{"\u5f85\u5ba1\u6279"}));
        } else if (bean.applyStatus == 2) {
            this.tv_forgetPin.setText((CharSequence)this.getString(R.string.sh_forget_pin_status, new Object[]{"\u5df2\u540c\u610f"}));
        } else if (bean.applyStatus == 3) {
            this.tv_forgetPin.setText(R.string.sh_forget_pin);
            this.showResetPinRejectDialog();
        }
    }

    private void resetPinApply() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_reset_apply_loading);
        this.netRespositoryASync.resetPinApply((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer != 0) {
                    if (integer == -10005) {
                        VHSMMainActivity.this.showNetErrorDialog();
                    } else if (integer == -20) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == -41) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)VHSMMainActivity.this, (int)R.string.sh_dev_reset_already_apply, (int)0).show();
                    VHSMMainActivity.this.doRefresh();
                }
            }
        });
    }

    private void queryResetPinApplyStatus() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_regist_apply_loading);
        this.businessRespAsync.queryResetPinApplyStatus((Consumer)new Consumer<ResetApplyBean>(){

            public void accept(ResetApplyBean resetApplyBean) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                VHSMMainActivity.this.showResetPinApplyResult(resetApplyBean.status);
            }
        });
    }

    private void showResetPinApplyResult(int status) {
        if (status != 20000) {
            if (status == 20001) {
                this.showNotifyDialog(R.string.sh_device_is_stopped);
            } else if (status == 20002) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.sh_reinit_apply_tobe_approval), (int)0).show();
            } else if (status == 20003) {
                this.showResetPinNotification();
            } else if (status == 20004) {
                this.showForApprovalDialog(-7);
            } else if (status == 20005) {
                this.resetPin();
            } else if (status == 20006) {
                this.tv_forgetPin.setText(R.string.sh_forget_pin);
                this.showResetPinRejectDialog();
            } else if (status == -41) {
                this.showNotifyDialog(R.string.sh_company_disable);
            } else if (status == -10005) {
                this.showNetErrorDialog();
            } else {
                Toast.makeText((Context)this, (CharSequence)ErrorMatcher.getErrorMsg(status), (int)0).show();
            }
        }
    }

    private void resetPin() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_reset_loading);
        this.netRespositoryASync.resetPin((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    VHSMMainActivity.this.showViewVhsmOK();
                    VHSMMainActivity.this.showResetPINApplyAgreeDialog();
                } else if (integer == -10005) {
                    VHSMMainActivity.this.showNetErrorDialog();
                } else if (integer == -41) {
                    VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                } else {
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                }
            }
        });
    }

    private void showResetPinRejectDialog() {
        DialogRepository.showNotifyDialog((Context)this, this.getString(R.string.sh_dev_reset_apply_reject), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.sendRejectRequest(4);
                dialog.dismiss();
            }
        });
    }

    private void toUse(int vhsmStatus) {
        if (vhsmStatus == 1) {
            this.doInit();
        } else {
            this.gotoVerifyPhone("");
        }
    }

    private void doInit() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_init_loading);
        this.netRespositoryASync.init((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    VHSMMainActivity.this.showViewVhsmOK();
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)VHSMMainActivity.this.getString(R.string.sh_dev_init_success), (int)0).show();
                } else if (integer == -10005) {
                    VHSMMainActivity.this.showNetErrorDialog();
                } else if (integer == -32) {
                    VHSMMainActivity.this.gotoVerifyPhone("");
                } else if (integer == -23 || integer == -35) {
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                } else if (integer == -41) {
                    VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                } else if (VHSMMainActivity.this.num == 0) {
                    VHSMMainActivity.this.num++;
                    VHSMMainActivity.this.showFailDialog();
                } else {
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                }
            }
        });
    }

    private void showFailDialog() {
        if (this.initFailDialog == null) {
            this.initFailDialog = new InitFailDialog((Context)this);
            this.initFailDialog.setPositiveButton(new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            this.initFailDialog.setTimeInter(new InitFailDialog.TimeInter(){

                @Override
                public void timeOut() {
                    VHSMMainActivity.this.doInit();
                }
            });
        }
        this.initFailDialog.show();
        this.initFailDialog.startTimer();
    }

    private void showViewVhsmOK() {
        this.hideViews();
        this.showCardId();
        this.tv_forgetPin.setVisibility(0);
        this.tv_forgetPin.setText(R.string.sh_forget_pin);
        this.tv_forgetPin.setTextColor(this.getResources().getColor(R.color.sh_single_btn_normal));
        this.tv_forgetPin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VHSMMainActivity.this.queryResetPinApplyStatus();
            }
        });
    }

    private void showResetPinNotification() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(R.string.sh_dev_reset_apply_notice).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.resetPinApply();
                dialog.dismiss();
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void showCardId() {
        String cardId = VhsmManager.getInstance((Context)this).getCardId();
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            this.showVHSM();
        } else {
            this.tv_cardId.setVisibility(0);
            this.tv_cardId.setTextColor(this.getResources().getColor(R.color.sh_cardId_color));
            this.tv_cardId.setTextSize(14.0f);
            this.tv_cardId.setText((CharSequence)VhsmManager.getInstance((Context)this).getCardId());
            this.tv_cardId.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.sh_detail, 0);
            this.tv_cardId.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VHSMMainActivity.this.startActivity(new Intent((Context)VHSMMainActivity.this, DeviceInfoActivity.class));
                }
            });
        }
    }

    private void showVHSM() {
        this.hideViews();
        this.tv_cardId.setVisibility(0);
        this.tv_cardId.setText(R.string.sh_vhsm);
        this.tv_cardId.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.tv_cardId.setTextColor(this.getResources().getColor(R.color.sh_vhsm_color));
        this.tv_cardId.setTextSize(16.0f);
    }

    private void showViewStatus(VHSMBean bean) {
        this.hideViews();
        if (bean.vhsmStatus == -1 || bean.vhsmStatus == 1) {
            this.showVHSM();
        } else {
            this.showCardId();
        }
        if (bean.applyStatus == 0 || bean.applyStatus == 4) {
            if (bean.vhsmStatus == -1 || bean.vhsmStatus == 1) {
                this.showNotInitialView(bean.vhsmStatus);
            } else if (bean.vhsmStatus == -5) {
                this.showFileNotExistDialog(bean);
            } else {
                this.showLockedDialog();
            }
        } else if (bean.applyStatus == 1) {
            this.showReApplyView(bean);
            this.tv_apply_status.setVisibility(0);
            this.tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            this.tv_apply_status.setTextColor(this.getResources().getColor(R.color.sh_single_btn_normal));
            if (bean.vhsmStatus == -1 || bean.vhsmStatus == 1) {
                this.tv_apply_status.setText(R.string.sh_regist_apply_submit);
            } else if (bean.vhsmStatus == -5) {
                this.tv_apply_status.setText(R.string.sh_reinit_apply_submit);
                this.showFileNotExistsTip();
            } else {
                this.tv_apply_status.setText(R.string.sh_unlock_apply_submit);
            }
        } else if (bean.applyStatus == 2) {
            if (bean.vhsmStatus == -5) {
                this.showFileNotExistsTip();
            }
            this.showAgreeApplyView(bean);
        } else if (bean.vhsmStatus == -1 || bean.vhsmStatus == 1) {
            this.showRejectApplyView(R.string.sh_regist_apply_deny, 5, bean);
        } else if (bean.vhsmStatus == -5) {
            this.showRejectApplyView(R.string.sh_reinit_apply_deny, 2, bean);
            this.showFileNotExistsTip();
        } else {
            this.showRejectApplyView(R.string.sh_unlock_apply_deny, 3, bean);
        }
    }

    private void showFileNotExistsTip() {
        this.tv_forgetPin.setVisibility(0);
        this.tv_forgetPin.setText(R.string.sh_file_not_exists_tip);
        this.tv_forgetPin.setTextColor(this.getResources().getColor(R.color.sh_modify_phone_text_color));
    }

    private void showRejectApplyView(@StringRes int str, int applyType, VHSMBean vhsmBean) {
        this.tv_apply_status.setVisibility(0);
        this.tv_apply_status.setTextColor(this.getResources().getColor(R.color.sh_deny_color));
        this.tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);
        this.tv_apply_status.setText(str);
        this.showReApplyView(vhsmBean);
        this.sendRejectRequest(applyType);
    }

    private void showAgreeApplyView(final VHSMBean bean) {
        this.tv_apply_status.setVisibility(0);
        this.tv_apply_status.setTextColor(this.getResources().getColor(R.color.sh_single_btn_normal));
        this.tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        String type = bean.vhsmStatus == -1 || bean.vhsmStatus == 1 ? "" : (bean.vhsmStatus == -5 ? "\u91cd\u65b0\u521d\u59cb\u5316" : "\u89e3\u9501");
        this.tv_apply_status.setText((CharSequence)this.getString(R.string.sh_apply_agree, new Object[]{type}));
        this.btn_operate.setVisibility(0);
        if (TextUtils.isEmpty((CharSequence)type)) {
            this.btn_operate.setText(R.string.sh_next);
        } else {
            this.btn_operate.setText((CharSequence)type);
        }
        this.btn_operate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (bean.vhsmStatus == -1 || bean.vhsmStatus == 1) {
                    VHSMMainActivity.this.gotoVerifyPhone(bean.deviceInfo.mobile);
                } else if (bean.vhsmStatus == -5) {
                    VHSMMainActivity.this.showReInitApplyAgreeDialog();
                } else {
                    VHSMMainActivity.this.unlock();
                }
            }
        });
    }

    private void sendRejectRequest(int applyType) {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            return;
        }
        this.netRespositoryASync.sendRejectRequest(applyType, (Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
            }
        });
    }

    private void showReApplyView(final VHSMBean vhsmBean) {
        this.btn_operate.setVisibility(0);
        this.btn_operate.setText(R.string.sh_reApply);
        this.btn_operate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VHSMMainActivity.this.reApply(vhsmBean);
            }
        });
    }

    private void gotoVerifyPhone(String mobile) {
        Intent intent = new Intent((Context)this, VhsmBindActivity.class);
        intent.putExtra(VhsmInitPresenter.MOBILE, mobile);
        this.startActivity(intent);
    }

    private void requestPermissions() {
        SPermission.with((Context)this).setMOUDLE(2).setmRequestCode(1).setPermissions(new String[]{"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE"}).setmOnPermissionListener(new OnPermissionListener(){

            public void onPermissionGranted() {
                VHSMMainActivity.this.doRefresh();
            }

            public void onPermissionDenied(String[] strings) {
                VHSMMainActivity.this.showPermissionDeniedDialog();
            }

            public void onPermissionDeniedAlways(String[] strings) {
                Log.d((String)VHSMMainActivity.this.tag, (String)"onPermissionDeniedAlways");
                VHSMMainActivity.this.showPermissionDeniedAlwaysDialog();
            }
        }).requestPermissions();
    }

    private void showLockedDialog() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(R.string.sh_locked_dialog_msg).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.unlockApply();
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void showResetPINApplyAgreeDialog() {
        DialogRepository.showTwoBtnDialog((Context)this, this.getString(R.string.sh_reset_apply_agree_dialog_msg), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
    }

    private void showReInitApplyAgreeDialog() {
        DialogRepository.showTextCenterHorizontalTwoBtnDialog((Context)this, this.getString(R.string.sh_reInit_apply_agree_dialog_msg), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.reInit();
            }
        });
    }

    private void reInitApply() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_reinit_apply_loading);
        this.netRespositoryASync.reInitApply((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                if (integer != 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    if (integer == -10005) {
                        VHSMMainActivity.this.showNetErrorDialog();
                    } else if (integer == -20) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == -41) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                    }
                } else {
                    VHSMBean vhsmBean = new VHSMBean();
                    vhsmBean.vhsmStatus = -5;
                    vhsmBean.applyStatus = 1;
                    VHSMMainActivity.this.showVHSMStatus(vhsmBean);
                }
            }
        });
    }

    private void reInit() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_reinit_loading);
        this.businessRespAsync.reInit((Consumer)new Consumer<Integer>(){

            public void accept(Integer ret) throws Exception {
                if (ret == 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)VHSMMainActivity.this.getString(R.string.sh_dev_reinit_success), (int)0).show();
                    VHSMMainActivity.this.showViewVhsmOK();
                } else if (ret == -10005) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    VHSMMainActivity.this.showNetErrorDialog();
                } else if (ret == -41) {
                    VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                } else {
                    VHSMMainActivity.this.queryVHSMState();
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(ret), (int)0).show();
                }
            }
        });
    }

    private void unlockApply() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_unlock_apply_loading);
        this.netRespositoryASync.unlockApply((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                if (integer != 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    if (integer == -10005) {
                        VHSMMainActivity.this.showNetErrorDialog();
                    } else if (integer == -20) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == -41) {
                        VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(integer), (int)0).show();
                    }
                } else {
                    VHSMMainActivity.this.queryVHSMState();
                }
            }
        });
    }

    private void unlock() {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_unlock_loading);
        this.businessRespAsync.unlock((Consumer)new Consumer<ApplyResult>(){

            public void accept(ApplyResult applyResult) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (applyResult.status == 0) {
                    VHSMMainActivity.this.showViewVhsmOK();
                    VHSMMainActivity.this.showResetPINApplyAgreeDialog();
                    VhsmManager.getInstance((Context)VHSMMainActivity.this).verifyPin(17, "111111");
                } else if (applyResult.status == -10005) {
                    VHSMMainActivity.this.showNetErrorDialog();
                } else if (applyResult.status == -41) {
                    VHSMMainActivity.this.showNotifyDialog(R.string.sh_company_disable);
                } else {
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(applyResult.status), (int)0).show();
                }
            }
        });
    }

    private void showFileNotExistDialog(VHSMBean vhsmBean) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(R.string.sh_file_not_exist_dialog_msg).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.reInitApply();
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void reApply(final VHSMBean vhsmBean) {
        if (!NetUtils.isNetworkConnected((Context)this)) {
            this.showNetErrorDialog();
            return;
        }
        if (this.isShowDialog()) {
            return;
        }
        this.showLoadingDialog(R.string.sh_dev_regist_apply_loading);
        this.netRespositoryASync.queryApplyStatus((Consumer)new Consumer<Pair<Integer, ArrayList<TypeStatus>>>(){

            public void accept(Pair<Integer, ArrayList<TypeStatus>> integerArrayListPair) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                int status = (Integer)integerArrayListPair.first;
                if (status == -10005) {
                    VHSMMainActivity.this.showNetErrorDialog();
                } else if (status == 0) {
                    int applyType = vhsmBean.vhsmStatus == -1 || vhsmBean.vhsmStatus == 1 ? 5 : (vhsmBean.vhsmStatus == -5 ? 2 : 3);
                    for (TypeStatus typeStatus : (ArrayList)integerArrayListPair.second) {
                        if (typeStatus.type != applyType) continue;
                        vhsmBean.applyStatus = typeStatus.status;
                        break;
                    }
                    if (vhsmBean.vhsmStatus == -1 || vhsmBean.vhsmStatus == 1) {
                        VHSMMainActivity.this.reApplyRegist(vhsmBean);
                    } else if (vhsmBean.vhsmStatus == -5) {
                        VHSMMainActivity.this.reApplyReInit(vhsmBean);
                    } else {
                        VHSMMainActivity.this.reApplyUnlock(vhsmBean);
                    }
                } else {
                    Toast.makeText((Context)VHSMMainActivity.this, (CharSequence)ErrorMatcher.getErrorMsg(status), (int)0).show();
                }
            }
        });
    }

    private void reApplyRegist(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == 2) {
            this.gotoVerifyPhone(vhsmBean.deviceInfo.mobile);
        } else if (vhsmBean.applyStatus == 1) {
            this.showForApprovalDialog(-1);
        } else {
            this.gotoVerifyPhone("");
        }
    }

    private void reApplyReInit(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == 2) {
            this.showReInitApplyAgreeDialog();
        } else if (vhsmBean.applyStatus == 1) {
            this.showForApprovalDialog(-5);
        } else {
            this.reInitApply();
        }
    }

    private void reApplyUnlock(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == 2) {
            this.unlock();
        } else if (vhsmBean.applyStatus == 1) {
            this.showForApprovalDialog(-6);
        } else {
            this.unlockApply();
        }
    }

    private void showForApprovalDialog(final int vhsmStatus) {
        String msg = vhsmStatus == -1 || vhsmStatus == 1 ? "\u4eba\u5458\u6ce8\u518c" : (vhsmStatus == -5 ? "\u91cd\u65b0\u521d\u59cb\u5316" : (vhsmStatus == -6 ? "\u89e3\u9501" : "\u5fd8\u8bb0PIN\u7801\u7684"));
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this).setMessage(this.getString(R.string.sh_dev_apply_submit, new Object[]{msg})).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(R.string.sh_apply_again, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (vhsmStatus == -1 || vhsmStatus == 1) {
                    VHSMMainActivity.this.gotoVerifyPhone("");
                } else if (vhsmStatus == -5) {
                    VHSMMainActivity.this.reInitApply();
                } else if (vhsmStatus == -6) {
                    VHSMMainActivity.this.unlockApply();
                } else {
                    VHSMMainActivity.this.resetPinApply();
                }
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void showPermissionDeniedDialog() {
        this.createCommonDialog(R.string.sh_getDevId_some_powers_has_forbid, R.string.sh_getDevId_some_powers_has_forbid_content, R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.commonDialog.dismiss();
                VHSMMainActivity.this.finish();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.commonDialog.dismiss();
                SPermission.getsPermission().activeSPermission();
                VHSMMainActivity.this.requestPermissions();
            }
        });
    }

    private void createCommonDialog(int titleRes, int contentRes, int leftButtonRes, int rightButtonRes, DialogInterface.OnClickListener leftButtonListener, DialogInterface.OnClickListener rightButtonListener) {
        this.commonDialog = new AlertDialog.Builder((Context)this).setTitle(titleRes).setMessage(contentRes).setPositiveButton(rightButtonRes, rightButtonListener).setNegativeButton(leftButtonRes, leftButtonListener).create();
        this.commonDialog.setCanceledOnTouchOutside(false);
        this.commonDialog.setCancelable(false);
        this.commonDialog.show();
    }

    private void showPermissionDeniedAlwaysDialog() {
        this.createCommonDialog(R.string.sh_acu_can_not_open_power_title, R.string.sh_acu_can_not_open_power_content1, R.string.sh_cancel, R.string.sh_acu_can_not_open_power_right_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.commonDialog.dismiss();
                VHSMMainActivity.this.finish();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VHSMMainActivity.this.commonDialog.dismiss();
                FuncUtils.getAppDetailSettingIntent((Context)VHSMMainActivity.this);
            }
        });
    }
}

