/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.DefaultToolbarListener;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.module.deviceinfo.ApplyResetInit;
import com.xdja.safehelper.view.CertItemView;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.CertInfo;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.DeviceInfoPresenter;
import com.xdja.vhsm.mvp.view.DeviceInfoViewBase;
import com.xdja.vhsm.utils.ContextCache;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import java.util.ArrayList;
import java.util.List;

public class DeviceInfoView
extends DeviceInfoViewBase<DeviceInfoPresenter> {
    private View rootView;
    private TextView tvTip;
    private LoadingDialog loadingDialog;
    private ApplyResetInit resetInit;
    private boolean isHideResetInit = true;
    private ViewStub stub_empty_file;
    private TextView dev_flag;
    private ViewStub stub_cert_list;
    private TextView tv_devicd_id;
    private TextView tv_cardId;
    private LinearLayout ll_cert_list;
    Button applyReInitBtn = null;

    protected int getLayoutId() {
        return R.layout.sh_layout_device_info;
    }

    protected void initContentView(View rootView) {
        this.rootView = rootView;
        this.tvTip = (TextView)rootView.findViewById(R.id.tv_tip);
    }

    protected void bindContentViewEvent(View view) {
    }

    public void onCreate(Activity context) {
        this.loadingDialog = new LoadingDialog((Context)context);
        super.onCreate(context);
        if (!this.isHideResetInit) {
            this.resetInit = new ApplyResetInit(this.getActivity(), this.loadingDialog, new ApplyResetInit.ResetInitCallback(){

                @Override
                public void resetInitSuccess() {
                    ((DeviceInfoPresenter)DeviceInfoView.this.bindPresenter).initDeviceConfig();
                }

                @Override
                public Button getApplyButton() {
                    return DeviceInfoView.this.applyReInitBtn;
                }
            });
        }
    }

    public void inflateEmptyFileLayout() {
        if (this.stub_empty_file == null) {
            this.stub_empty_file = (ViewStub)this.rootView.findViewById(R.id.stub_empty_file);
            this.stub_empty_file.inflate();
            this.dev_flag = (TextView)this.rootView.findViewById(R.id.dev_flag);
        }
        this.dev_flag.setText((CharSequence)this.getActivity().getString(R.string.sh_empty_file, new Object[]{FuncUtils.getDevId((Context)this.getActivity())}));
        this.tvTip.setVisibility(8);
    }

    public void inflateCertListLayout() {
        String deviceId;
        if (this.stub_cert_list == null) {
            this.stub_cert_list = (ViewStub)this.rootView.findViewById(R.id.stub_cert_list);
            this.stub_cert_list.inflate();
            this.tv_devicd_id = (TextView)this.rootView.findViewById(R.id.tv_devicd_id);
            this.tv_cardId = (TextView)this.rootView.findViewById(R.id.tv_cardId);
            this.ll_cert_list = (LinearLayout)this.rootView.findViewById(R.id.ll_cert_list);
        }
        if (TextUtils.isEmpty((CharSequence)(deviceId = FuncUtils.getDevId((Context)this.getActivity())))) {
            return;
        }
        this.tv_devicd_id.setText((CharSequence)deviceId);
        this.tvTip.setVisibility(0);
    }

    public boolean preParserCardIdAndAllCerts() {
        if (this.loadingDialog.isShowing()) {
            return false;
        }
        this.loadingDialog.showLoading(R.string.sh_dev_cert_loading);
        return true;
    }

    public void readCardIdAndAllCertCallback(Pair<String, List<CertInfo>> pair) {
        this.loadingDialog.finishLoadingDialog();
        this.showCertInfo(pair);
    }

    public boolean preQueryApplyStatus() {
        if (this.isHideResetInit) {
            return false;
        }
        if (!NetUtils.isNetworkConnected((Context)this.getActivity())) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
            return false;
        }
        return true;
    }

    public void queryApplyStatusCallback(Pair<Integer, ArrayList<TypeStatus>> pair) {
        if (this.getActivity().isFinishing() || this.getActivity().isDestroyed()) {
            return;
        }
        this.loadingDialog.finishLoadingDialog();
        if ((Integer)pair.first == 0) {
            TypeStatus reInitTypeStatus = null;
            for (TypeStatus typeStatus : (ArrayList)pair.second) {
                if (typeStatus.type != 2) continue;
                reInitTypeStatus = typeStatus;
                break;
            }
            if (reInitTypeStatus != null && this.resetInit != null) {
                this.resetInit.showBtnStatus(reInitTypeStatus.status);
            }
        } else if ((Integer)pair.first == -10005) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
        } else {
            ToastUtils.makeText((Context)this.getActivity(), ErrorMatcher.getErrorMsg((Integer)pair.first), 0).show();
        }
    }

    private void showCertInfo(Pair<String, List<CertInfo>> pair) {
        String cardId = (String)pair.first;
        this.tv_cardId.setText((CharSequence)cardId);
        this.tv_cardId.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isCopy = FuncUtils.copy((String)DeviceInfoView.this.tv_cardId.getText().toString());
                if (isCopy) {
                    ToastUtils.makeText(ContextCache.getContext(), R.string.sh_cardid_has_been_copeid, 0).show();
                }
            }
        });
        List certInfos = (List)pair.second;
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        this.ll_cert_list.removeAllViews();
        if (certInfos == null || certInfos.size() == 0) {
            this.ll_cert_list.addView(this.getEmptyCertView(), (ViewGroup.LayoutParams)lp);
            this.applyReInitBtn = (Button)this.rootView.findViewById(R.id.apply_reInit1);
        } else {
            for (CertInfo certInfo : certInfos) {
                this.ll_cert_list.addView((View)this.getCertItemView(certInfo), (ViewGroup.LayoutParams)lp);
            }
            this.applyReInitBtn = (Button)this.rootView.findViewById(R.id.apply_reInit);
        }
        if (!this.isHideResetInit) {
            this.applyReInitBtn.setVisibility(0);
        }
    }

    private CertItemView getCertItemView(CertInfo certInfo) {
        return new CertItemView((Context)this.getActivity()).setCertType(certInfo.certType).setContainer(certInfo.container + "").setGiver(certInfo.issuerCN).setUser(certInfo.subjectDN.substring(0, certInfo.subjectDN.indexOf(",OU"))).setValidPeriod(certInfo.validity).setSN(certInfo.sn);
    }

    private View getEmptyCertView() {
        return LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.sh_layout_empty_cert, null);
    }

    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener(){

            public Context getContext() {
                return DeviceInfoView.this.getActivity();
            }

            public int leftTitleResId() {
                return R.string.sh_dev_info;
            }
        };
    }

    public DeviceInfoPresenter binderPresenter() {
        return new DeviceInfoPresenter();
    }
}

