/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.CountDownTimer;
import android.support.annotation.StringRes;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.DefaultToolbarListener;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.safehelper.view.VerificationAction;
import com.xdja.safehelper.view.VerificationCodeEditText;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.OperateWithCodePresenter;
import com.xdja.vhsm.mvp.view.OperateWithCodeViewBase;
import com.xdja.vhsm.utils.NetUtils;

public class OperateWithCodeView
extends AbstractCommonView<OperateWithCodePresenter>
implements OperateWithCodeViewBase<OperateWithCodePresenter> {
    private TextView tv_tip;
    private TextView tv_send_code;
    private TextView tv_code_tip;
    private TextView tv_retry;
    private TextView mobile_tip;
    private VerificationCodeEditText et_verify_code;
    private LoadingDialog loadingDialog;
    public static final String TAG_MOBILE = "tag_mobile";
    public static final String TAG_OPERATE = "tag_operate";
    public static final String UNLOCK = "unlock";
    public static final String REINIT = "reinit";
    public static final String RESETPIN = "resetpin";
    private String mobile;
    private String operate;
    private CountDownTimer timer;
    private int TIME = 60;

    protected int getLayoutId() {
        return R.layout.sh_layout_verify_code_next;
    }

    protected void initContentView(View rootView) {
        this.tv_tip = (TextView)rootView.findViewById(R.id.tv_tip);
        this.tv_send_code = (TextView)rootView.findViewById(R.id.tv_send_code);
        this.tv_code_tip = (TextView)rootView.findViewById(R.id.tv_code_tip);
        this.tv_retry = (TextView)rootView.findViewById(R.id.tv_retry);
        this.mobile_tip = (TextView)rootView.findViewById(R.id.mobile_tip);
        this.et_verify_code = (VerificationCodeEditText)rootView.findViewById(R.id.et_verify_code);
        this.loadingDialog = new LoadingDialog((Context)this.getActivity());
    }

    protected void bindContentViewEvent(View view) {
        this.mobile = this.getActivity().getIntent().getStringExtra(TAG_MOBILE);
        this.operate = this.getActivity().getIntent().getStringExtra(TAG_OPERATE);
        this.tv_tip.setText(R.string.sh_verify_mobile_by_code);
        this.showMobile(this.mobile);
        this.tv_code_tip.setVisibility(4);
        this.tv_retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OperateWithCodeView.this.sendCode();
            }
        });
        String str_mobile_tip = this.getActivity().getString(R.string.sh_mobile_not_use);
        SpannableStringBuilder spaString = this.getSpaString(str_mobile_tip, str_mobile_tip.indexOf("\uff1f") + 1, str_mobile_tip.length());
        this.mobile_tip.setText((CharSequence)spaString);
        this.mobile_tip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OperateWithCodeView.this.showModifyMobileDialog();
            }
        });
        this.et_verify_code.setOnVerificationCodeChangedListener(new VerificationAction.OnVerificationCodeChangedListener(){

            @Override
            public void onVerCodeChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void onInputCompleted(CharSequence s) {
                OperateWithCodeView.this.hideKeyBoard();
                OperateWithCodeView.this.doNext(OperateWithCodeView.this.operate, s.toString(), OperateWithCodeView.this.mobile);
            }
        });
    }

    public void onCreate(Activity context) {
        super.onCreate(context);
        this.sendCode();
    }

    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener(){

            public Context getContext() {
                return OperateWithCodeView.this.getActivity();
            }

            public int leftTitleResId() {
                return R.string.sh_verify_mobile;
            }
        };
    }

    private void showMobile(String mobile) {
        this.mobile = mobile;
        this.tv_send_code.setText((CharSequence)this.getActivity().getString(R.string.sh_code_to_mobile, new Object[]{mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")}));
    }

    private void doNext(String operate, String code, String mobile) {
        if (!NetUtils.isNetworkConnected((Context)this.getActivity())) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
            return;
        }
        if (this.loadingDialog.isShowing()) {
            return;
        }
        if (operate.equals(UNLOCK)) {
            this.loadingDialog.showLoading(R.string.sh_loading_unlock);
            ((OperateWithCodePresenter)this.bindPresenter).unlockByCode(code, mobile);
        } else if (operate.equals(REINIT)) {
            this.loadingDialog.showLoading(R.string.sh_loading_reinit);
            ((OperateWithCodePresenter)this.bindPresenter).reInitByCode(code, mobile);
        } else {
            this.loadingDialog.showLoading(R.string.sh_loading_resetpin);
            ((OperateWithCodePresenter)this.bindPresenter).resetPinByCode(code, mobile);
        }
    }

    private SpannableStringBuilder getSpaString(String str, int start, int end) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        sb.append((CharSequence)str);
        ForegroundColorSpan span = new ForegroundColorSpan(this.getActivity().getResources().getColor(R.color.sh_single_btn_normal));
        sb.setSpan((Object)span, start, end, 33);
        return sb;
    }

    private void showModifyMobileDialog() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this.getActivity()).setMessage(R.string.sh_modify_mobile).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setTextCenterHorizontal(true).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void sendCode() {
        if (!NetUtils.isNetworkConnected((Context)this.getActivity())) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
            return;
        }
        ((OperateWithCodePresenter)this.bindPresenter).getMobileAndCode();
        this.tv_code_tip.setVisibility(4);
        this.startTimer();
        this.showKeyBoard();
    }

    private void startTimer() {
        this.showTimeLeftView(this.TIME);
        this.timer = new CountDownTimer(this.TIME * 1000, 1000L){

            public void onTick(long millisUntilFinished) {
                if (millisUntilFinished > 1000L) {
                    OperateWithCodeView.this.showTimeLeftView(millisUntilFinished / 1000L);
                } else {
                    OperateWithCodeView.this.cancelTimer();
                }
            }

            public void onFinish() {
            }
        };
        this.timer.start();
    }

    private void cancelTimer() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.showReSendView();
    }

    private void showTimeLeftView(long left) {
        this.tv_retry.setEnabled(false);
        String time = this.getActivity().getString(R.string.sh_time_left, new Object[]{left});
        this.tv_retry.setTextColor(this.getActivity().getResources().getColor(R.color.sh_cardId_color));
        this.tv_retry.setText((CharSequence)time);
    }

    private void showReSendView() {
        this.tv_retry.setEnabled(true);
        this.tv_retry.setTextColor(this.getActivity().getResources().getColor(R.color.sh_vhsm_text_color));
        this.tv_retry.setText(R.string.sh_re_send);
    }

    public void showViewAfterSendCode(int ret, String mobile) {
        if (ret == 0) {
            this.showMobile(mobile);
        } else if (ret == -10005) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
        } else {
            ToastUtils.makeText((Context)this.getActivity(), ErrorMatcher.getErrorMsg(ret), 0).show();
        }
    }

    public void showViewAfterResetPin(int ret) {
        this.showViewAfterCode(ret, R.string.sh_resetpin_by_code_success);
    }

    public void showViewAfterUnlock(int ret) {
        this.showViewAfterCode(ret, R.string.sh_unlock_by_code_success);
    }

    private void showViewAfterCode(int ret, @StringRes int strRes) {
        this.loadingDialog.finishLoadingDialog();
        if (ret == 0) {
            this.showOperateSuccessDialog(strRes);
        } else if (ret == -10005) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
        } else if (ret == -27 || ret == -28) {
            this.tv_code_tip.setVisibility(0);
            this.et_verify_code.clearComposingText();
        } else {
            ToastUtils.makeText((Context)this.getActivity(), ErrorMatcher.getErrorMsg(ret), 0).show();
        }
    }

    private void showOperateSuccessDialog(@StringRes int resStr) {
        String str = this.getActivity().getString(resStr);
        SpannableStringBuilder spaString = this.getSpaString(str, str.indexOf("1"), str.lastIndexOf("1") + 1);
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this.getActivity()).setSpannableMessage(spaString).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                OperateWithCodeView.this.getActivity().finish();
            }
        }).setTextCenterHorizontal(true).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    public void showViewAfterReInit(int ret) {
        this.showViewAfterCode(ret, R.string.sh_reinit_by_code_success);
    }

    public OperateWithCodePresenter binderPresenter() {
        return new OperateWithCodePresenter();
    }

    private void showKeyBoard() {
        this.getActivity().getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                OperateWithCodeView.this.et_verify_code.requestFocus();
                OperateWithCodeView.this.et_verify_code.setSelection(OperateWithCodeView.this.et_verify_code.getText().length());
                OperateWithCodeView.this.et_verify_code.toggleSoftInput(OperateWithCodeView.this.et_verify_code.getContext());
            }
        }, 300L);
    }

    private void hideKeyBoard() {
        this.et_verify_code.toggleSoftInput(this.et_verify_code.getContext());
    }
}

