/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.airbnb.lottie.LottieAnimationView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.DefaultToolbarListener;
import com.xdja.safehelper.view.SHItemDecoration;
import com.xdja.safehelper.view.SelfCheckAdapter;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.safehelper.view.VerifyPinDialog;
import com.xdja.vhsm.bean.CheckItemInfo;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.SelfCheckPresenter;
import com.xdja.vhsm.mvp.view.SelfCheckViewBase;

public class SelfCheckView
extends SelfCheckViewBase<SelfCheckPresenter> {
    private RecyclerView mRecyclerView;
    private SelfCheckAdapter adapter;
    private TextView textCheckStatus;
    private LottieAnimationView animStatus;
    VerifyPinDialog dialog = null;
    private int status = 0;
    private int problemNum = 0;

    protected int getLayoutId() {
        return R.layout.sh_activity_self_check;
    }

    protected void initContentView(View rootView) {
        this.textCheckStatus = (TextView)rootView.findViewById(R.id.text_check_status);
        this.animStatus = (LottieAnimationView)rootView.findViewById(R.id.image_status);
        this.mRecyclerView = (RecyclerView)rootView.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 1, false));
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SHItemDecoration((Context)this.getActivity(), (int)this.getActivity().getResources().getDimension(R.dimen.base_24)));
        this.adapter = new SelfCheckAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    protected void bindContentViewEvent(View view) {
    }

    public void onCreate(Activity context) {
        super.onCreate(context);
        this.showVerifyPinDialog();
    }

    private void showVerifyPinDialog() {
        if (this.dialog == null) {
            this.dialog = new VerifyPinDialog((Context)this.getActivity());
            this.dialog.show();
            this.dialog.setCallBack(new VerifyPinDialog.CallBack(){

                @Override
                public void okCallBack(String pin) {
                    SelfCheckView.this.startCheck(pin);
                }

                @Override
                public void cancelCallBack() {
                    SelfCheckView.this.dialog.dismiss();
                    SelfCheckView.this.getActivity().finish();
                }
            });
        }
    }

    private void startCheck(String pin) {
        this.adapter.clear();
        if (!this.isNetworkConnected()) {
            if (this.dialog != null) {
                this.dialog.setVerifyPinErrorInfo(this.getActivity().getString(R.string.sh_activity_self_check_net_is_not_connect));
            }
            return;
        }
        this.dialog.dismiss();
        this.status = 0;
        this.checkIngAnim();
        ((SelfCheckPresenter)this.bindPresenter).startCheck(pin);
    }

    public void checkNextCallback(CheckItemInfo info) {
        if (this.getActivity().isFinishing() || this.getActivity().isDestroyed()) {
            return;
        }
        if (info.tag.equals("openCard")) {
            this.dismissVerifyPinDialog();
        }
        if (!info.isContinue) {
            this.status = 1;
            this.checkFailAnim();
        } else if (info.ret != 0) {
            this.checkProblemAnim();
            this.status = -1;
        }
        this.showCheckInfo(info);
    }

    public void completeCheck() {
        this.showCheckCompleteStatus();
    }

    private void showCheckInfo(CheckItemInfo info) {
        this.adapter.addInfo(info);
    }

    private void checkIngAnim() {
        this.showCheckIngStatus();
        if (!this.animStatus.isAnimating()) {
            this.animStatus.setImageAssetsFolder("images/");
            this.animStatus.setAnimation("sh_checking.json");
            this.animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.animStatus.playAnimation();
        }
    }

    private void showCheckIngStatus() {
        String src = this.getActivity().getString(R.string.sh_activity_self_check_ing);
        this.textCheckStatus.setText((CharSequence)src);
    }

    private void checkProblemAnim() {
        ++this.problemNum;
        if (!this.animStatus.isAnimating() || this.status >= 0) {
            if (this.animStatus.isAnimating()) {
                this.animStatus.clearAnimation();
            }
            this.animStatus.setImageAssetsFolder("images/");
            this.animStatus.setAnimation("sh_check_problem.json");
            this.animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.animStatus.playAnimation();
        }
        String src = this.getActivity().getString(R.string.sh_activity_self_check_problem);
        this.textCheckStatus.setText((CharSequence)String.format(src, this.problemNum));
    }

    private void checkFailAnim() {
        if (this.animStatus.isAnimating()) {
            this.animStatus.clearAnimation();
        }
        this.animStatus.setImageAssetsFolder("images/");
        this.animStatus.setAnimation("sh_check_fail.json");
        this.animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.animStatus.loop(false);
        this.animStatus.playAnimation();
    }

    private void showCheckCompleteStatus() {
        String info = "";
        if (this.status == 0) {
            info = this.getActivity().getString(R.string.sh_activity_self_check_ok);
        } else if (this.status < 0) {
            String src = this.getActivity().getString(R.string.sh_activity_self_check_problem);
            info = String.format(src, this.problemNum);
        } else if (this.status > 0) {
            info = this.getActivity().getString(R.string.sh_activity_self_check_fail);
        }
        this.textCheckStatus.setText((CharSequence)info);
        this.animStatus.loop(false);
    }

    private boolean isNetworkConnected() {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
        if (mNetworkInfo != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    private void dismissVerifyPinDialog() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    private void showMsg(final String msg) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtils.makeText(SelfCheckView.this.getActivity().getApplicationContext(), msg, 1).show();
            }
        });
    }

    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener(){

            public Context getContext() {
                return SelfCheckView.this.getActivity();
            }

            public int leftTitleResId() {
                return R.string.sh_activity_self_check_title;
            }
        };
    }

    public SelfCheckPresenter binderPresenter() {
        return new SelfCheckPresenter();
    }
}

