/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.DefaultToolbarListener;
import com.xdja.safehelper.module.setting.SHQueryDeviceResultCallback;
import com.xdja.safehelper.module.setting.SHSettingItemData;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.SHItemDecoration;
import com.xdja.safehelper.view.SettingAdapter;
import com.xdja.vhsm.bean.SettingItemInfo;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.vhsm.mvp.presenter.SettingPresenter;
import com.xdja.vhsm.utils.NetUtils;
import java.util.List;

public class SettingView
extends AbstractCommonView<SettingPresenter> {
    RecyclerView recyclerView;
    SettingAdapter adapter;
    TextView textVersion;
    TextView textPrivacy;
    private LoadingDialog loadingDialog;

    protected int getLayoutId() {
        return R.layout.sh_activity_setting;
    }

    protected void initContentView(View rootView) {
        this.textVersion = (TextView)rootView.findViewById(R.id.activity_setting_version);
        this.textPrivacy = (TextView)rootView.findViewById(R.id.activity_setting_privacy);
        this.recyclerView = (RecyclerView)rootView.findViewById(R.id.activity_setting_recyclerview);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 1, false));
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SHItemDecoration((Context)this.getActivity(), (int)this.getActivity().getResources().getDimension(R.dimen.base_48)));
        this.adapter = new SettingAdapter();
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    protected void bindContentViewEvent(View view) {
    }

    public void onCreate(Activity context) {
        super.onCreate(context);
        this.initRecyclerView();
        String version = this.getActivity().getString(R.string.sh_setting_main_version) + ((SettingPresenter)this.bindPresenter).getVersion();
        this.textVersion.setText((CharSequence)version);
        this.loadingDialog = new LoadingDialog((Context)context);
    }

    private void initRecyclerView() {
        List<SettingItemInfo> itemInfos = new SHSettingItemData(this).getSettingItemInfo();
        this.adapter.addInfo(itemInfos);
    }

    public void requestDeviceInfo(Class enterClass) {
        if (!NetUtils.isNetworkConnected((Context)this.getActivity())) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
            return;
        }
        if (this.loadingDialog.isShowing()) {
            return;
        }
        this.loadingDialog.showLoading(R.string.sh_get_identify_loading);
        ((SettingPresenter)this.bindPresenter).queryDevice((ConsumerCallback)new SHQueryDeviceResultCallback(this, enterClass));
    }

    public void onResume() {
        super.onResume();
        this.adapter.notifyDataSetChanged();
    }

    public void finishLoadingDialog() {
        this.loadingDialog.dismiss();
    }

    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener(){

            public Context getContext() {
                return SettingView.this.getActivity();
            }

            public int leftTitleResId() {
                return R.string.sh_setting_title;
            }
        };
    }

    public SettingPresenter binderPresenter() {
        return new SettingPresenter();
    }
}

