/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.vhsm.mvp.common.ToolbarListener;

public class ToolbarWrapper {
    Context context;
    View view;
    private Toolbar toolbar;
    private TextView tvLeftTitle;
    private TextView tvRightText;
    private ImageView img_setting;
    ToolbarListener toolbarListener;

    public void initToolbar(ToolbarListener listener, View view) {
        this.toolbarListener = listener;
        this.view = view;
        this.context = view.getContext();
        this.initToolbarView(view);
        this.setViewVisibility();
        this.initToolbarListener();
        this.setContent();
    }

    void initToolbarView(View view) {
        this.toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        this.tvLeftTitle = (TextView)view.findViewById(R.id.left_title_tv);
        this.tvRightText = (TextView)view.findViewById(R.id.tv_refresh);
        this.img_setting = (ImageView)view.findViewById(R.id.tar_img_setting);
    }

    private void setViewVisibility() {
        if (!this.toolbarListener.isShowToolbar()) {
            this.view.setVisibility(8);
        }
        if (this.toolbarListener.isSupportLeftBack()) {
            Drawable lDrawable = this.context.getResources().getDrawable(R.drawable.sh_icon_back);
            this.tvLeftTitle.setCompoundDrawablesWithIntrinsicBounds(lDrawable, null, null, null);
        }
    }

    private void initToolbarListener() {
        this.tvLeftTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToolbarWrapper.this.toolbarListener.leftClickListener();
            }
        });
        this.tvRightText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToolbarWrapper.this.toolbarListener.rightClickListener();
            }
        });
        this.img_setting.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToolbarWrapper.this.toolbarListener.rightSetClickListener();
            }
        });
    }

    private void setContent() {
        if (this.toolbarListener.leftTitleResId() != 0) {
            this.tvLeftTitle.setText(this.toolbarListener.leftTitleResId());
        }
        if (this.toolbarListener.rightTitleResId() != 0) {
            this.tvRightText.setText(this.toolbarListener.rightTitleResId());
        }
        if (this.toolbarListener.rightSetIconResId() != 0) {
            this.img_setting.setVisibility(0);
            this.img_setting.setImageResource(this.toolbarListener.rightSetIconResId());
        }
    }
}

