/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.BindIdentifyActivity;
import com.xdja.safehelper.activity.view.DefaultToolbarListener;
import com.xdja.safehelper.module.vhsmbind.SHBindPersonResultCallback;
import com.xdja.safehelper.module.vhsmbind.SHGetCodeResultCallback;
import com.xdja.safehelper.module.vhsmbind.SHVhsmInitResultCallback;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.InitFailDialog;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.vhsm.mvp.presenter.VhsmInitPresenter;
import com.xdja.vhsm.mvp.view.VhsmInitViewBase;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;

public class VhsmInitView
extends VhsmInitViewBase<VhsmInitPresenter> {
    private TextView tv_tip;
    private TextView tv_get_code;
    private EditText et_phone;
    private EditText et_verify_code;
    private Button btn_operate;
    private ImageView ic_verify_code;
    private ImageView ic_phone;
    private LoadingDialog loadingDialog;
    private ConsumerCallback getCodeResultCallback;
    private ConsumerCallback bindPersonResultCallback;
    private ConsumerCallback vhsmInitResultCallback;
    private MyCustomDialog singleDialog = null;
    private InitFailDialog initFailDialog;

    public VhsmInitPresenter binderPresenter() {
        return new VhsmInitPresenter();
    }

    protected int getLayoutId() {
        return R.layout.sh_layout_verify_mobile;
    }

    protected void initContentView(View rootView) {
        this.tv_tip = (TextView)rootView.findViewById(R.id.tv_tip);
        this.et_phone = (EditText)rootView.findViewById(R.id.et_phone);
        this.et_verify_code = (EditText)rootView.findViewById(R.id.et_verify_code);
        this.tv_get_code = (TextView)rootView.findViewById(R.id.tv_get_code);
        this.btn_operate = (Button)rootView.findViewById(R.id.btn_operate);
        this.ic_phone = (ImageView)rootView.findViewById(R.id.ic_phone);
        this.ic_verify_code = (ImageView)rootView.findViewById(R.id.ic_verify_code);
    }

    protected void bindContentViewEvent(View view) {
        this.et_phone.addTextChangedListener(new TextWatcher(){
            private CharSequence temp;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                this.temp = s;
            }

            public void afterTextChanged(Editable s) {
                if (this.temp.length() > 0 && VhsmInitView.this.et_verify_code.getText().length() > 0) {
                    VhsmInitView.this.btn_operate.setEnabled(true);
                } else {
                    VhsmInitView.this.btn_operate.setEnabled(false);
                }
                if (this.temp.length() > 0) {
                    VhsmInitView.this.setPhoneLeftIcon(true);
                } else {
                    VhsmInitView.this.setPhoneLeftIcon(false);
                }
            }
        });
        this.et_verify_code.addTextChangedListener(new TextWatcher(){
            private CharSequence temp;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                this.temp = s;
            }

            public void afterTextChanged(Editable s) {
                if (this.temp.length() > 0 && VhsmInitView.this.et_phone.getText().length() > 0) {
                    VhsmInitView.this.btn_operate.setEnabled(true);
                } else {
                    VhsmInitView.this.btn_operate.setEnabled(false);
                }
                if (this.temp.length() > 0) {
                    VhsmInitView.this.setVerifyCodeLeftIcon(true);
                } else {
                    VhsmInitView.this.setVerifyCodeLeftIcon(false);
                }
            }
        });
        this.tv_get_code.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VhsmInitView.this.preGetCode(VhsmInitView.this.et_phone.getText().toString())) {
                    ((VhsmInitPresenter)VhsmInitView.this.bindPresenter).getCode(VhsmInitView.this.et_phone.getText().toString(), VhsmInitView.this.getCodeResultCallback);
                }
            }
        });
        this.btn_operate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VhsmInitView.this.preBindPerson(VhsmInitView.this.et_phone.getText().toString(), VhsmInitView.this.et_verify_code.getText().toString())) {
                    VhsmInitView.this.showLoadingDialog();
                    ((VhsmInitPresenter)VhsmInitView.this.bindPresenter).bindPerson(VhsmInitView.this.et_phone.getText().toString(), VhsmInitView.this.et_verify_code.getText().toString(), VhsmInitView.this.bindPersonResultCallback);
                }
            }
        });
    }

    public void onCreate(Activity context) {
        super.onCreate(context);
        this.loadingDialog = new LoadingDialog((Context)context);
        this.loadingDialog.setVerticalLayout(true);
        if (((VhsmInitPresenter)this.bindPresenter).isEmptyExtrasMobile()) {
            this.tv_tip.setText(R.string.sh_tip);
            this.btn_operate.setText(R.string.sh_bind);
            this.setPhoneLeftIcon(false);
        } else {
            this.et_phone.setText((CharSequence)((VhsmInitPresenter)this.bindPresenter).mobile);
            this.et_phone.setEnabled(false);
            this.tv_tip.setText(R.string.sh_tip_regist_apply_agree);
            this.btn_operate.setText(R.string.sh_safe_verify);
            this.setPhoneLeftIcon(true);
        }
        this.tv_get_code.setText(R.string.sh_get_code);
        this.btn_operate.setEnabled(false);
        this.setVerifyCodeLeftIcon(false);
        this.getCodeResultCallback = new SHGetCodeResultCallback(this);
        this.bindPersonResultCallback = new SHBindPersonResultCallback(this);
        this.vhsmInitResultCallback = new SHVhsmInitResultCallback(this);
    }

    private boolean preGetCode(String mobile) {
        if (!this.verifyInputMobileInfo(mobile)) {
            return false;
        }
        return this.verifyNetWorkState();
    }

    private boolean preBindPerson(String mobile, String code) {
        if (!this.verifyInputInfo(mobile, code)) {
            return false;
        }
        if (!this.verifyNetWorkState()) {
            return false;
        }
        return !this.loadingDialog.isShowing();
    }

    public void timerStart(int time) {
        this.tv_get_code.setEnabled(false);
        this.tv_get_code.setText((CharSequence)(this.getActivity().getString(R.string.sh_reget_code) + "(" + time + ")"));
    }

    public void timerIng(int time) {
        this.tv_get_code.setText((CharSequence)(this.getActivity().getString(R.string.sh_reget_code) + "(" + time + ")"));
    }

    public void timerFinish(int time) {
        this.tv_get_code.setEnabled(true);
        this.tv_get_code.setText(R.string.sh_get_code);
    }

    public void codeSendCallback() {
        this.tv_get_code.setEnabled(true);
        this.tv_get_code.setText(R.string.sh_get_code);
    }

    public void initVhsm() {
        if (!this.verifyNetWorkState()) {
            this.dismissLoadingDialog();
            return;
        }
        ((VhsmInitPresenter)this.bindPresenter).doInit(this.vhsmInitResultCallback);
    }

    public boolean verifyInputMobileInfo(String mobile) {
        if (TextUtils.isEmpty((CharSequence)mobile)) {
            ToastUtils.makeText((Context)this.getActivity(), this.getActivity().getString(R.string.sh_phone_null), 0).show();
            return false;
        }
        if (!FuncUtils.isPhone((String)mobile)) {
            ToastUtils.makeText((Context)this.getActivity(), this.getActivity().getString(R.string.sh_phone_invalid), 0).show();
            return false;
        }
        return true;
    }

    public boolean verifyInputInfo(String mobile, String code) {
        if (!this.verifyInputMobileInfo(mobile)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            ToastUtils.makeText((Context)this.getActivity(), this.getActivity().getString(R.string.sh_code_null), 0).show();
            return false;
        }
        return true;
    }

    private boolean verifyNetWorkState() {
        if (!NetUtils.isNetworkConnected((Context)this.getActivity())) {
            DialogRepository.showNetErrorDialog((Context)this.getActivity());
            return false;
        }
        return true;
    }

    public void showLoadingDialog() {
        this.loadingDialog.showLoading(R.string.sh_bind_person_loading);
    }

    public void dismissLoadingDialog() {
        this.loadingDialog.finishLoadingDialog();
    }

    public void showIdentifyDialog() {
        DialogRepository.showTwoBtnDialog((Context)this.getActivity(), this.getActivity().getResources().getString(R.string.sh_not_in_table), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VhsmInitView.this.toBindIdentify();
            }
        });
    }

    public void showDialogAboutSingle() {
        if (this.singleDialog == null) {
            this.singleDialog = new MyCustomDialog.Builder((Context)this.getActivity()).setMessage(R.string.sh_single_error).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                }
            }).create();
            this.singleDialog.setCancelable(false);
            this.singleDialog.setCanceledOnTouchOutside(false);
        }
        this.singleDialog.show();
    }

    private void toBindIdentify() {
        Intent intent = new Intent((Context)this.getActivity(), BindIdentifyActivity.class);
        intent.putExtra(BindIdentifyActivity.TAG_PHONE, this.et_phone.getText().toString());
        this.getActivity().startActivity(intent);
        this.getActivity().finish();
    }

    public void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog((Context)this.getActivity(), this.getActivity().getString(res), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VhsmInitView.this.getActivity().finish();
            }
        });
    }

    public void showFailDialog() {
        if (this.initFailDialog == null) {
            this.initFailDialog = new InitFailDialog((Context)this.getActivity());
            this.initFailDialog.setPositiveButton(new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            this.initFailDialog.setTimeInter(new InitFailDialog.TimeInter(){

                @Override
                public void timeOut() {
                    if (!VhsmInitView.this.verifyNetWorkState()) {
                        return;
                    }
                    VhsmInitView.this.showLoadingDialog();
                    VhsmInitView.this.initVhsm();
                }
            });
        }
        this.initFailDialog.show();
        this.initFailDialog.startTimer();
    }

    private void setPhoneLeftIcon(boolean hasInput) {
        if (hasInput) {
            this.ic_phone.setImageResource(R.drawable.sh_phone);
        } else {
            this.ic_phone.setImageResource(R.drawable.sh_phone_no_input);
        }
    }

    private void setVerifyCodeLeftIcon(boolean hasInput) {
        if (hasInput) {
            this.ic_verify_code.setImageResource(R.drawable.sh_verify_code);
        } else {
            this.ic_verify_code.setImageResource(R.drawable.sh_verify_code_no_input);
        }
    }

    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener(){

            public Context getContext() {
                return VhsmInitView.this.getActivity();
            }

            public int leftTitleResId() {
                return R.string.sh_verify_mobile;
            }
        };
    }
}

