/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.module.deviceinfo;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.Button;
import com.xdja.initvhsm.net.bean.business.ReInitBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.utils.NetUtils;
import io.reactivex.functions.Consumer;

public class ApplyResetInit {
    private Activity activity;
    private LoadingDialog loadingDialog;
    private BusinessRespAsync businessRespAsync;
    private NetRespositoryASync netRespositoryASync;
    private ResetInitCallback resetInitCallback;

    public ApplyResetInit(Activity activity, LoadingDialog loadingDialog, ResetInitCallback resetInitCallback) {
        this.activity = activity;
        this.loadingDialog = loadingDialog;
        this.businessRespAsync = new BusinessRespAsync();
        this.netRespositoryASync = new NetRespositoryASync();
        this.resetInitCallback = resetInitCallback;
    }

    public void applyReInit() {
        if (!NetUtils.isNetworkConnected((Context)this.activity)) {
            DialogRepository.showNetErrorDialog((Context)this.activity);
            return;
        }
        if (this.loadingDialog.isShowing()) {
            return;
        }
        this.loadingDialog.showLoading(R.string.sh_dev_reinit_apply_loading);
        this.businessRespAsync.reInitApply((Consumer)new Consumer<ReInitBean>(){

            public void accept(ReInitBean applyResult) throws Exception {
                ApplyResetInit.this.loadingDialog.finishLoadingDialog();
                ApplyResetInit.this.showReInitApplyStatus(applyResult.status);
            }
        });
    }

    private void showReInitApplyStatus(int status) {
        if (status == 10000) {
            ToastUtils.makeText((Context)this.activity, R.string.sh_reinit_apply_submit, 0).show();
            this.showBtnStatus(1);
        } else if (status == 10001) {
            this.showNotifyDialog(R.string.sh_device_is_stopped);
        } else if (status == 10002) {
            ToastUtils.makeText((Context)this.activity, this.activity.getString(R.string.sh_unlock_apply_tobe_approval), 0).show();
        } else if (status == 10003) {
            ToastUtils.makeText((Context)this.activity, this.activity.getString(R.string.sh_reset_apply_tobe_approval), 0).show();
        } else if (status == 10007) {
            this.showDialogNotApply();
        } else if (status == 10004) {
            this.showForApprovalDialog();
        } else if (status == 10005) {
            this.showReInitApplyAgreeDialog();
        } else if (status == 10006) {
            this.showRejectDialog();
        } else if (status == -10005) {
            DialogRepository.showNetErrorDialog((Context)this.activity);
        } else if (status == -41) {
            this.showNotifyDialog(R.string.sh_company_disable);
        } else {
            ToastUtils.makeText((Context)this.activity, ErrorMatcher.getErrorMsg(status), 0).show();
        }
    }

    private void showRejectDialog() {
        DialogRepository.showNotifyDialog((Context)this.activity, this.activity.getString(R.string.sh_reinit_apply_reject), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ApplyResetInit.this.sendRejectRequest();
                ApplyResetInit.this.showBtnStatus(0);
                dialog.dismiss();
            }
        });
    }

    private void showForApprovalDialog() {
        String msg = "\u91cd\u65b0\u521d\u59cb\u5316";
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this.activity).setMessage(this.activity.getString(R.string.sh_dev_apply_submit, new Object[]{msg})).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(R.string.sh_apply_again, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                ApplyResetInit.this.reInitApply();
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    private void showReInitApplyAgreeDialog() {
        DialogRepository.showTextCenterHorizontalTwoBtnDialog((Context)this.activity, this.activity.getString(R.string.sh_reInit_apply_agree_dialog_msg), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                ApplyResetInit.this.reInit();
            }
        });
    }

    private void reInit() {
        if (!NetUtils.isNetworkConnected((Context)this.activity)) {
            DialogRepository.showNetErrorDialog((Context)this.activity);
            return;
        }
        if (this.loadingDialog.isShowing()) {
            return;
        }
        this.loadingDialog.showLoading(R.string.sh_dev_reinit_loading);
        this.businessRespAsync.reInit((Consumer)new Consumer<Integer>(){

            public void accept(Integer ret) throws Exception {
                ApplyResetInit.this.loadingDialog.finishLoadingDialog();
                if (ret == 0) {
                    ApplyResetInit.this.resetInitCallback.resetInitSuccess();
                    ToastUtils.makeText((Context)ApplyResetInit.this.activity, R.string.sh_dev_reinit_success, 0).show();
                } else if (ret == -10005) {
                    DialogRepository.showNetErrorDialog((Context)ApplyResetInit.this.activity);
                } else if (ret == -41) {
                    ApplyResetInit.this.showNotifyDialog(R.string.sh_company_disable);
                } else {
                    ToastUtils.makeText((Context)ApplyResetInit.this.activity, ErrorMatcher.getErrorMsg(ret), 0).show();
                }
            }
        });
    }

    private void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog((Context)this.activity, this.activity.getString(res), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                ApplyResetInit.this.activity.finish();
            }
        });
    }

    private void reInitApply() {
        if (!NetUtils.isNetworkConnected((Context)this.activity)) {
            DialogRepository.showNetErrorDialog((Context)this.activity);
            return;
        }
        if (this.loadingDialog.isShowing()) {
            return;
        }
        this.loadingDialog.showLoading(R.string.sh_dev_reinit_apply_loading);
        this.netRespositoryASync.reInitApply((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                ApplyResetInit.this.loadingDialog.finishLoadingDialog();
                if (integer == 0) {
                    ToastUtils.makeText((Context)ApplyResetInit.this.activity, R.string.sh_reinit_apply_submit, 0).show();
                    ApplyResetInit.this.showBtnStatus(1);
                } else if (integer == -10005) {
                    DialogRepository.showNetErrorDialog((Context)ApplyResetInit.this.activity);
                } else if (integer == -20) {
                    ApplyResetInit.this.showNotifyDialog(R.string.sh_device_is_stopped);
                } else if (integer == -41) {
                    ApplyResetInit.this.showNotifyDialog(R.string.sh_company_disable);
                } else {
                    ToastUtils.makeText((Context)ApplyResetInit.this.activity, ErrorMatcher.getErrorMsg(integer), 0).show();
                }
            }
        });
    }

    private void showDialogNotApply() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)this.activity).setMessage(R.string.sh_reinit_to_apply).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ApplyResetInit.this.reInitApply();
                dialog.dismiss();
            }
        }).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                ApplyResetInit.this.showBtnStatus(0);
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    public void showBtnStatus(int applyStatus) {
        Button applyStatusView = this.resetInitCallback.getApplyButton();
        if (applyStatusView == null) {
            return;
        }
        if (applyStatus == 2) {
            applyStatusView.setText((CharSequence)this.activity.getString(R.string.sh_apply_reinit_status, new Object[]{"\u5df2\u540c\u610f"}));
        } else if (applyStatus == 1) {
            applyStatusView.setText((CharSequence)this.activity.getString(R.string.sh_apply_reinit_status, new Object[]{"\u5f85\u5ba1\u6279"}));
        } else if (applyStatus == 3) {
            applyStatusView.setText((CharSequence)this.activity.getString(R.string.sh_apply_reinit_status, new Object[]{"\u5df2\u62d2\u7edd"}));
            this.sendRejectRequest();
        } else {
            applyStatusView.setText(R.string.sh_apply_reinit);
        }
        applyStatusView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ApplyResetInit.this.applyReInit();
            }
        });
    }

    private void sendRejectRequest() {
        if (!NetUtils.isNetworkConnected((Context)this.activity)) {
            return;
        }
        this.netRespositoryASync.sendRejectRequest(2, (Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
            }
        });
    }

    public static interface ResetInitCallback {
        public void resetInitSuccess();

        public Button getApplyButton();
    }
}

