/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.module.setting;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Pair;
import com.xdja.initvhsm.net.bean.DeviceInfo;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.IdentifyInfoActivity;
import com.xdja.safehelper.activity.view.IdentifyInfoView;
import com.xdja.safehelper.activity.view.SettingView;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import java.io.Serializable;

public class SHQueryDeviceResultCallback
implements ConsumerCallback<Pair<Integer, DeviceInfo>> {
    private SettingView settingView;
    private Class enterClass;

    public SHQueryDeviceResultCallback(SettingView settingView, Class enterClass) {
        this.settingView = settingView;
        this.enterClass = enterClass;
    }

    public void resultCallback(Pair<Integer, DeviceInfo> ret) {
        if (this.settingView.getActivity().isFinishing() || this.settingView.getActivity().isDestroyed()) {
            return;
        }
        this.settingView.finishLoadingDialog();
        int result = (Integer)ret.first;
        if (result == 0) {
            if (this.enterClass == IdentifyInfoActivity.class) {
                this.showIdentify((DeviceInfo)ret.second);
            } else if (this.enterClass == DeviceInfoActivity.class) {
                this.showDeviceInfo((DeviceInfo)ret.second);
            }
        } else if (result == -10005) {
            DialogRepository.showNetErrorDialog((Context)this.settingView.getActivity());
        } else {
            String errorInf = ErrorMatcher.getErrorMsg(result);
            if (!TextUtils.isEmpty((CharSequence)errorInf)) {
                ToastUtils.makeText((Context)this.settingView.getActivity(), errorInf, 0).show();
            }
        }
    }

    private void showIdentify(DeviceInfo deviceInfo) {
        if (deviceInfo.personId == null && deviceInfo.deviceUnbindEnable == 1) {
            ToastUtils.makeText((Context)this.settingView.getActivity(), R.string.sh_get_identify_nothing, 1).show();
            return;
        }
        if (deviceInfo.personId == null && deviceInfo.deviceUnbindEnable == 0) {
            ToastUtils.makeText((Context)this.settingView.getActivity(), R.string.sh_get_identify_info_not_regist, 1).show();
            return;
        }
        if ((deviceInfo.status == 2 || deviceInfo.status == 3) && deviceInfo.personId == null) {
            ToastUtils.makeText((Context)this.settingView.getActivity(), R.string.sh_device_is_invalid, 1).show();
            return;
        }
        if (deviceInfo == null) {
            ToastUtils.makeText((Context)this.settingView.getActivity(), R.string.sh_get_identify_nothing, 1).show();
            return;
        }
        Intent intent = new Intent((Context)this.settingView.getActivity(), IdentifyInfoActivity.class);
        intent.putExtra(IdentifyInfoView.PERSON_INFO, (Serializable)deviceInfo);
        this.settingView.getActivity().startActivity(intent);
    }

    private void showDeviceInfo(DeviceInfo deviceInfo) {
        if (deviceInfo.status == 1) {
            ToastUtils.makeText((Context)this.settingView.getActivity(), R.string.sh_devinfo_not_init, 0).show();
        }
        Intent intent = new Intent((Context)this.settingView.getActivity(), DeviceInfoActivity.class);
        this.settingView.getActivity().startActivity(intent);
    }
}

