/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.module.setting;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.ChangePinActivity;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.IdentifyInfoActivity;
import com.xdja.safehelper.activity.SelfCheckActivity;
import com.xdja.safehelper.activity.ServerConfigActivity;
import com.xdja.safehelper.activity.view.SettingView;
import com.xdja.safehelper.update.Update;
import com.xdja.vhsm.bean.SettingItemInfo;
import com.xdja.vhsm.utils.AssetsConfigUtils;
import java.util.ArrayList;
import java.util.List;

public class SHSettingItemData {
    private SettingView settingView;
    private View.OnClickListener personListener = new View.OnClickListener(){

        public void onClick(View v) {
            SHSettingItemData.this.settingView.requestDeviceInfo(IdentifyInfoActivity.class);
        }
    };
    private View.OnClickListener deviceInfoListener = new View.OnClickListener(){

        public void onClick(View v) {
            SHSettingItemData.this.settingView.requestDeviceInfo(DeviceInfoActivity.class);
        }
    };
    private View.OnClickListener changePinListener = new View.OnClickListener(){

        public void onClick(View v) {
            Intent intent = new Intent((Context)SHSettingItemData.this.settingView.getActivity(), ChangePinActivity.class);
            SHSettingItemData.this.settingView.getActivity().startActivity(intent);
        }
    };
    private View.OnClickListener updateListener = new View.OnClickListener(){

        public void onClick(View v) {
            Update.getInstance().checkUpdate(SHSettingItemData.this.settingView.getActivity(), true);
        }
    };

    public SHSettingItemData(SettingView settingView) {
        this.settingView = settingView;
    }

    public List<SettingItemInfo> getSettingItemInfo() {
        ArrayList<SettingItemInfo> settingItemInfoList = new ArrayList<SettingItemInfo>();
        SettingItemInfo idInfo = new SettingItemInfo();
        idInfo.info = this.settingView.getActivity().getString(R.string.sh_setting_id_info);
        idInfo.iconRes = R.drawable.sh_ic_item_idinfo;
        idInfo.listener = this.personListener;
        settingItemInfoList.add(idInfo);
        SettingItemInfo deviceInfo = new SettingItemInfo();
        deviceInfo.info = this.settingView.getActivity().getString(R.string.sh_setting_device_info);
        deviceInfo.iconRes = R.drawable.sh_ic_item_device;
        deviceInfo.listener = this.deviceInfoListener;
        settingItemInfoList.add(deviceInfo);
        SettingItemInfo checkAbility = new SettingItemInfo();
        checkAbility.info = this.settingView.getActivity().getString(R.string.sh_setting_check_ability);
        checkAbility.iconRes = R.drawable.sh_ic_item_checkability;
        checkAbility.listener = this.create(SelfCheckActivity.class);
        settingItemInfoList.add(checkAbility);
        SettingItemInfo changePin = new SettingItemInfo();
        changePin.info = this.settingView.getActivity().getString(R.string.sh_setting_change_pin);
        changePin.listener = this.changePinListener;
        changePin.iconRes = R.drawable.sh_ic_item_change_pin;
        settingItemInfoList.add(changePin);
        SettingItemInfo checkNew = new SettingItemInfo();
        checkNew.info = this.settingView.getActivity().getString(R.string.sh_setting_check_new);
        checkNew.listener = this.updateListener;
        checkNew.iconRes = R.drawable.sh_ic_item_update;
        settingItemInfoList.add(checkNew);
        boolean isConfigServer = AssetsConfigUtils.getInstance().getDefaultConfigServerFlag();
        if (isConfigServer) {
            SettingItemInfo addressConfig = new SettingItemInfo();
            addressConfig.info = this.settingView.getActivity().getString(R.string.sh_setting_address_config);
            addressConfig.listener = this.create(ServerConfigActivity.class);
            settingItemInfoList.add(addressConfig);
        }
        return settingItemInfoList;
    }

    private View.OnClickListener create(final Class intoClass) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)SHSettingItemData.this.settingView.getActivity(), intoClass);
                SHSettingItemData.this.settingView.getActivity().startActivity(intent);
            }
        };
    }
}

