/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.update;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.view.View;
import com.xdja.safehelper.ActivityStackManager;
import com.xdja.safehelper.R;
import com.xdja.safehelper.update.SHUpdateManager;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ProgressBarDialog;
import com.xdja.safehelper.view.TitleAndContentDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.update.CheckCallback;
import com.xdja.update.DownloadCallback;
import com.xdja.update.UpdateManager;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.DownLoadFileError;
import com.xdja.vhsm.utils.ContextCache;
import com.xdja.vhsm.utils.NetUtils;
import java.io.File;

public class Update {
    private static Update update = new Update();

    private Update() {
    }

    public static Update getInstance() {
        return update;
    }

    public void init() {
        UpdateManager.getInstance().install(ContextCache.getContext());
    }

    public void checkUpdate(final Activity activity, final boolean isShowToast) {
        UpdateManager.getInstance().checkUpdate(new CheckCallback(){

            public void onChecking() {
            }

            public void onCheckResult(@NonNull CheckResult checkResult) {
                if (checkResult.getResult().equals("0")) {
                    SHUpdateManager.getInstance().hasNewVersion = true;
                    Update.this.showUpdateDialog(activity, isShowToast, checkResult);
                } else if (checkResult.getResult().equals("1")) {
                    SHUpdateManager.getInstance().hasNewVersion = false;
                    if (isShowToast) {
                        ToastUtils.makeText(ContextCache.getContext(), R.string.sh_update_newest, 0).show();
                    }
                } else if (isShowToast) {
                    ToastUtils.makeText(ContextCache.getContext(), R.string.sh_update_fail, 0).show();
                }
            }
        });
    }

    private void showUpdateDialog(final Activity activity, final boolean isShowToast, final CheckResult checkResult) {
        String ver = ((CheckResult.Update)checkResult.getUpdates().get(0)).getVersion();
        TitleAndContentDialog.Builder builder = new TitleAndContentDialog.Builder((Context)activity).setTitle(R.string.sh_update_title).setMessage(activity.getString(R.string.sh_update_content, new Object[]{ver})).setPositiveButton(R.string.sh_update_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                Update.this.download(activity, isShowToast, checkResult);
            }
        });
        final int tag = ((CheckResult.Update)checkResult.getUpdates().get(0)).getUpdateTag();
        builder.setNegativeButton(R.string.sh_update_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                UpdateManager.getInstance().stopDownload();
                if (tag == 1) {
                    ActivityStackManager.getInstance().removeAll();
                }
            }
        });
        TitleAndContentDialog titleAndContentDialog = builder.create();
        titleAndContentDialog.setCancelable(false);
        titleAndContentDialog.setCanceledOnTouchOutside(false);
        titleAndContentDialog.show();
    }

    private void download(Activity activity, boolean isShowToast, CheckResult checkResult) {
        if (!NetUtils.isNetworkConnected((Context)activity)) {
            ToastUtils.makeText(ContextCache.getContext(), R.string.sh_net_error, 0).show();
            return;
        }
        if (!NetUtils.isWifiConnected((Context)activity)) {
            this.showNetDialog(activity, isShowToast, checkResult);
            return;
        }
        this.downloadFile(activity, isShowToast, checkResult);
    }

    private void downloadFile(final Activity activity, final boolean isShowToast, CheckResult checkResult) {
        final int tag = ((CheckResult.Update)checkResult.getUpdates().get(0)).getUpdateTag();
        final ProgressBarDialog progressBarDialog = new ProgressBarDialog((Context)activity);
        progressBarDialog.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateManager.getInstance().stopDownload();
                if (tag == 1 && !isShowToast) {
                    activity.finish();
                }
            }
        });
        progressBarDialog.setCancelable(false);
        progressBarDialog.setCanceledOnTouchOutside(false);
        UpdateManager.getInstance().downloadFile((CheckResult.Update.File)((CheckResult.Update)checkResult.getUpdates().get(0)).getFiles().get(0), new DownloadCallback(){

            public void onStart(@NonNull String fileId) {
                progressBarDialog.show();
            }

            public void onProgress(@NonNull String fileId, long totalSize, long cSize) {
                int progress = Float.valueOf((float)cSize / (float)totalSize * 100.0f).intValue();
                progressBarDialog.updateProgress(progress);
            }

            public void onStop(@NonNull String fileId) {
            }

            public void onError(@NonNull String fileId, @NonNull DownLoadFileError error, Exception ex) {
                UpdateManager.getInstance().stopDownload();
                progressBarDialog.dismiss();
                if (isShowToast) {
                    if (error.getKey() == 2) {
                        ToastUtils.makeText(ContextCache.getContext(), R.string.sh_net_error, 0).show();
                    } else {
                        ToastUtils.makeText(ContextCache.getContext(), R.string.sh_download_fail, 0).show();
                    }
                } else if (error.getKey() == 2) {
                    Update.this.showDownLoadFailDialog(activity, R.string.sh_net_error);
                } else {
                    Update.this.showDownLoadFailDialog(activity, R.string.sh_download_fail);
                }
            }

            public void onComplete(@NonNull String fileId, @NonNull String filePath) {
                progressBarDialog.updateProgress(100);
                progressBarDialog.dismiss();
                Update.this.install(filePath);
            }

            public int unit() {
                return 0x100000;
            }

            @NonNull
            public String downloadDir() {
                return ContextCache.getContext().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS).getPath();
            }
        });
    }

    private void showNetDialog(final Activity activity, final boolean isShowToast, final CheckResult checkResult) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder((Context)activity).setMessage(R.string.sh_update_net_status).setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(R.string.sh_update_continue, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                Update.this.downloadFile(activity, isShowToast, checkResult);
            }
        }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    public void showDownLoadFailDialog(final Activity activity, @StringRes int strRes) {
        MyCustomDialog netErrorDialog = new MyCustomDialog.Builder((Context)activity).setMessage(strRes).setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
                activity.finish();
            }
        }).create();
        netErrorDialog.setCancelable(false);
        netErrorDialog.setCanceledOnTouchOutside(false);
        netErrorDialog.show();
    }

    private boolean install(String filePath) {
        try {
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                return false;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 24) {
                intent.addFlags(1);
            }
            intent.setDataAndType(this.getPathUri(ContextCache.getContext(), filePath), "application/vnd.android.package-archive");
            ContextCache.getContext().startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            ToastUtils.makeText(ContextCache.getContext(), "\u5b89\u88c5\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d", 0).show();
            return false;
        }
        catch (Error error) {
            error.printStackTrace();
            ToastUtils.makeText(ContextCache.getContext(), "\u5b89\u88c5\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d", 0).show();
            return false;
        }
        return true;
    }

    private Uri getPathUri(Context context, String filePath) {
        Uri uri;
        if (Build.VERSION.SDK_INT >= 24) {
            String packageName = context.getPackageName();
            uri = FileProvider.getUriForFile((Context)context, (String)(packageName + ".fileProvider"), (File)new File(filePath));
        } else {
            uri = Uri.fromFile((File)new File(filePath));
        }
        return uri;
    }
}

