/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.SHItemDecoration;
import com.xdja.vhsm.bean.IdentifyItem;
import java.util.List;

public class IdentifyAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<IdentifyItem> identifyItems;

    public IdentifyAdapter(List<IdentifyItem> identifyItems) {
        this.identifyItems = identifyItems;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.sh_layout_identify_item0, viewGroup, false);
        return new VH(view);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        ((VH)viewHolder).bindData(position);
    }

    public int getItemCount() {
        if (this.identifyItems == null) {
            return 0;
        }
        return this.identifyItems.size();
    }

    public void initRecyclerView(RecyclerView recyclerView, Context context) {
        LinearLayoutManager layoutManager = new LinearLayoutManager(recyclerView.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        layoutManager.setOrientation(1);
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SHItemDecoration(context, (int)context.getResources().getDimension(R.dimen.base_24)));
        recyclerView.setAdapter((RecyclerView.Adapter)this);
    }

    private class VH
    extends RecyclerView.ViewHolder {
        private TextView tv_name;
        private TextView tv_content;
        private ImageView eye;

        public VH(View itemView) {
            super(itemView);
            this.tv_name = (TextView)itemView.findViewById(R.id.tv_name);
            this.tv_content = (TextView)itemView.findViewById(R.id.tv_content);
            this.eye = (ImageView)itemView.findViewById(R.id.eye);
        }

        public void bindData(int pos) {
            IdentifyItem identifyItem = (IdentifyItem)IdentifyAdapter.this.identifyItems.get(pos);
            this.tv_name.setText((CharSequence)identifyItem.key);
            if (identifyItem.key.equals(this.tv_name.getContext().getString(R.string.sh_bind_id))) {
                final String value = identifyItem.value;
                if (TextUtils.isEmpty((CharSequence)value)) {
                    return;
                }
                final String id2 = value.substring(0, 10) + "****" + value.substring(14, identifyItem.value.length());
                this.tv_content.setText((CharSequence)id2);
                this.eye.setVisibility(0);
                this.eye.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (VH.this.tv_content.getText().toString().contains("*")) {
                            VH.this.tv_content.setText((CharSequence)value);
                            VH.this.eye.setImageResource(R.drawable.sh_close_eye);
                        } else {
                            VH.this.tv_content.setText((CharSequence)id2);
                            VH.this.eye.setImageResource(R.drawable.sh_eye);
                        }
                    }
                });
            } else {
                this.tv_content.setText((CharSequence)identifyItem.value);
                this.eye.setVisibility(8);
            }
        }
    }
}

