/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.SafeHelperCommonDialog;

public class MyCustomDialog
extends SafeHelperCommonDialog {
    private Builder builder;

    public MyCustomDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.builder.message != null || this.builder.msgStyle != null) {
            TextView tv_content = (TextView)this.findViewById(R.id.tv_content);
            if (!this.builder.centerHorizontal) {
                tv_content.setGravity(3);
            }
            if (this.builder.message != null) {
                tv_content.setText((CharSequence)this.builder.message);
            }
            if (this.builder.msgStyle != null) {
                tv_content.setText((CharSequence)this.builder.msgStyle);
            }
        }
        if (this.builder.positiveButtonText != null) {
            Button btn_positive = (Button)this.findViewById(R.id.btn_positive);
            btn_positive.setText((CharSequence)this.builder.positiveButtonText);
            btn_positive.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MyCustomDialog.this.builder.positiveButtonClickListener.onClick((DialogInterface)MyCustomDialog.this, -1);
                }
            });
        }
        if (this.builder.negativeButtonText != null) {
            Button btn_negative = (Button)this.findViewById(R.id.btn_negative);
            btn_negative.setText((CharSequence)this.builder.negativeButtonText);
            btn_negative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MyCustomDialog.this.builder.negativeButtonClickListener.onClick((DialogInterface)MyCustomDialog.this, -2);
                }
            });
        }
    }

    private void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Override
    public int getLayoutId() {
        if (TextUtils.isEmpty((CharSequence)this.builder.negativeButtonText)) {
            return R.layout.sh_new_dialog_with_singlebtn;
        }
        return R.layout.sh_new_dialog;
    }

    public static class Builder {
        private Context context;
        private String message;
        private SpannableStringBuilder msgStyle;
        private String positiveButtonText;
        private String negativeButtonText;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;
        private boolean centerHorizontal = true;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setSpannableMessage(SpannableStringBuilder style2) {
            this.msgStyle = style2;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            this.message = this.context.getString(message);
            return this;
        }

        public Builder setPositiveButton(String positiveButtonText, DialogInterface.OnClickListener onClickListener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText, DialogInterface.OnClickListener onClickListener) {
            this.positiveButtonText = this.context.getString(positiveButtonText);
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, DialogInterface.OnClickListener onClickListener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButtonText, DialogInterface.OnClickListener onClickListener) {
            this.negativeButtonText = this.context.getString(negativeButtonText);
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setTextCenterHorizontal(boolean centerHorizontal) {
            this.centerHorizontal = centerHorizontal;
            return this;
        }

        public MyCustomDialog create() {
            MyCustomDialog dialog = new MyCustomDialog(this.context);
            dialog.setBuilder(this);
            return dialog;
        }
    }
}

