/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.xdja.safehelper.R;

public class SHItemDecoration
extends RecyclerView.ItemDecoration {
    private int mDividerHeight = 40;
    private Paint mPaint = new Paint(1);
    private int left;

    public SHItemDecoration(Context context, int left) {
        this.mPaint.setColor(Color.parseColor((String)"#E3E2E3"));
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDividerHeight = (int)context.getResources().getDimension(R.dimen.sh_decoration_height);
        this.left = left;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        this.drawHorizontalLine(c, parent, state);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.set(0, 0, 0, this.mDividerHeight);
    }

    private void drawHorizontalLine(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        canvas.save();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childAt = parent.getChildAt(i);
            int left = this.left;
            int right = parent.getWidth();
            int top = childAt.getBottom();
            int bottom = childAt.getBottom() + this.mDividerHeight;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
        canvas.restore();
    }
}

