/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.update.SHUpdateManager;
import com.xdja.vhsm.bean.SettingItemInfo;
import java.util.ArrayList;
import java.util.List;

public class SettingAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<SettingItemInfo> infoList = new ArrayList();

    public void addInfo(SettingItemInfo info) {
        this.infoList.add(info);
        this.notifyDataSetChanged();
    }

    public void addInfo(List<SettingItemInfo> info) {
        this.infoList.clear();
        this.infoList.addAll(info);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.infoList.clear();
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.sh_list_setting_single, viewGroup, false);
        return new SettingItemViewHolder(view);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        SettingItemInfo item;
        if (this.infoList != null && (item = this.infoList.get(i)) != null) {
            ((SettingItemViewHolder)viewHolder).bindData(item);
        }
    }

    public int getItemCount() {
        return this.infoList.size();
    }

    class SettingItemViewHolder
    extends RecyclerView.ViewHolder {
        TextView textInfo;
        private View itemView;
        ImageView imageView;
        View upgradeRemindView;

        public SettingItemViewHolder(View itemView) {
            super(itemView);
            this.textInfo = (TextView)itemView.findViewById(R.id.text_info);
            this.imageView = (ImageView)itemView.findViewById(R.id.iv_item_setting);
            this.upgradeRemindView = itemView.findViewById(R.id.upgrade_remid);
            this.itemView = itemView;
        }

        public void bindData(SettingItemInfo info) {
            this.textInfo.setText((CharSequence)info.info);
            if (info.iconRes != 0) {
                this.imageView.setVisibility(0);
                this.imageView.setImageResource(info.iconRes);
            } else {
                this.imageView.setVisibility(8);
            }
            if (info.listener != null) {
                this.itemView.setOnClickListener(info.listener);
            }
            this.upgradeRemindView.setVisibility(8);
            try {
                if (info.info.equals(this.itemView.getContext().getString(R.string.sh_setting_check_new)) && SHUpdateManager.getInstance().hasNewVersion) {
                    this.upgradeRemindView.setVisibility(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

