/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.SafeHelperCommonDialog;

public class TitleAndContentDialog
extends SafeHelperCommonDialog {
    private Builder builder;

    public TitleAndContentDialog(Context context) {
        super(context);
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Override
    public int getLayoutId() {
        if (this.builder.negativeButtonText != null) {
            return R.layout.sh_update_dailog;
        }
        return R.layout.sh_force_update_dailog;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.builder == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.title)) {
            TextView tv_title = (TextView)this.findViewById(R.id.tv_title);
            tv_title.setText((CharSequence)this.builder.title);
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.message)) {
            TextView tv_content = (TextView)this.findViewById(R.id.tv_content);
            tv_content.setText((CharSequence)this.builder.message);
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.positiveButtonText) && this.builder.positiveButtonClickListener != null) {
            Button btn_positive = (Button)this.findViewById(R.id.btn_positive);
            btn_positive.setText((CharSequence)this.builder.positiveButtonText);
            btn_positive.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TitleAndContentDialog.this.builder.positiveButtonClickListener.onClick((DialogInterface)TitleAndContentDialog.this, -1);
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.negativeButtonText) && this.builder.negativeButtonClickListener != null) {
            Button btn_negative = (Button)this.findViewById(R.id.btn_negative);
            btn_negative.setText((CharSequence)this.builder.negativeButtonText);
            btn_negative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TitleAndContentDialog.this.builder.negativeButtonClickListener.onClick((DialogInterface)TitleAndContentDialog.this, -1);
                }
            });
        }
    }

    public static class Builder {
        private Context context;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;
        private String message = null;
        private String title = null;
        private String positiveButtonText = null;
        private String negativeButtonText = null;
        TextView tv_title;
        TextView tv_content;
        Button btn_negative;
        Button btn_positive;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setPositiveButton(String positiveButtonText, DialogInterface.OnClickListener onClickListener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText, DialogInterface.OnClickListener onClickListener) {
            this.positiveButtonText = this.context.getString(positiveButtonText);
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, DialogInterface.OnClickListener onClickListener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButtonText, DialogInterface.OnClickListener onClickListener) {
            this.negativeButtonText = this.context.getString(negativeButtonText);
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            this.message = this.context.getString(message);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            this.title = this.context.getString(title);
            return this;
        }

        public TitleAndContentDialog create() {
            TitleAndContentDialog titleAndContentDialog = new TitleAndContentDialog(this.context);
            titleAndContentDialog.setBuilder(this);
            return titleAndContentDialog;
        }
    }
}

