/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.VerificationAction;
import java.util.Timer;
import java.util.TimerTask;

public class VerificationCodeEditText
extends AppCompatEditText
implements VerificationAction,
TextWatcher {
    private static final int DEFAULT_CURSOR_DURATION = 400;
    private int mFigures;
    private int mVerCodeMargin;
    private int mBottomSelectedColor;
    private int mBottomNormalColor;
    private float mBottomLineHeight;
    private int mSelectedBackgroundColor;
    private int mCursorWidth;
    private int mCursorColor;
    private int mCursorDuration;
    private VerificationAction.OnVerificationCodeChangedListener onCodeChangedListener;
    private int mCurrentPosition = 0;
    private int mEachRectLength = 0;
    private Paint mSelectedBackgroundPaint;
    private Paint mNormalBackgroundPaint;
    private Paint mBottomSelectedPaint;
    private Paint mBottomNormalPaint;
    private Paint mCursorPaint;
    private boolean isCursorShowing;
    private TimerTask mCursorTimerTask;
    private Timer mCursorTimer;

    public VerificationCodeEditText(Context context) {
        this(context, null);
    }

    public VerificationCodeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerificationCodeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)17170445));
        this.initPaint();
        this.initCursorTimer();
        this.setFocusableInTouchMode(true);
        super.addTextChangedListener((TextWatcher)this);
    }

    private void initPaint() {
        this.mSelectedBackgroundPaint = new Paint();
        this.mSelectedBackgroundPaint.setColor(this.mSelectedBackgroundColor);
        this.mNormalBackgroundPaint = new Paint();
        this.mNormalBackgroundPaint.setColor(this.getColor(17170445));
        this.mBottomSelectedPaint = new Paint();
        this.mBottomNormalPaint = new Paint();
        this.mBottomSelectedPaint.setColor(this.mBottomSelectedColor);
        this.mBottomNormalPaint.setColor(this.mBottomNormalColor);
        this.mBottomSelectedPaint.setStrokeWidth(this.mBottomLineHeight);
        this.mBottomNormalPaint.setStrokeWidth(this.mBottomLineHeight);
        this.mCursorPaint = new Paint();
        this.mCursorPaint.setAntiAlias(true);
        this.mCursorPaint.setColor(this.mCursorColor);
        this.mCursorPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mCursorPaint.setStrokeWidth((float)this.mCursorWidth);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.sh_VerCodeEditText);
        this.mFigures = ta.getInteger(R.styleable.sh_VerCodeEditText_figures, 4);
        this.mVerCodeMargin = (int)ta.getDimension(R.styleable.sh_VerCodeEditText_verCodeMargin, 0.0f);
        this.mBottomSelectedColor = ta.getColor(R.styleable.sh_VerCodeEditText_bottomLineSelectedColor, this.getCurrentTextColor());
        this.mBottomNormalColor = ta.getColor(R.styleable.sh_VerCodeEditText_bottomLineNormalColor, this.getColor(0x1060000));
        this.mBottomLineHeight = ta.getDimension(R.styleable.sh_VerCodeEditText_bottomLineHeight, (float)this.dp2px(5));
        this.mSelectedBackgroundColor = ta.getColor(R.styleable.sh_VerCodeEditText_selectedBackgroundColor, this.getColor(0x1060000));
        this.mCursorWidth = (int)ta.getDimension(R.styleable.sh_VerCodeEditText_cursorWidth, (float)this.dp2px(1));
        this.mCursorColor = ta.getColor(R.styleable.sh_VerCodeEditText_cursorColor, this.getColor(0x1060000));
        this.mCursorDuration = ta.getInteger(R.styleable.sh_VerCodeEditText_cursorDuration, 400);
        ta.recycle();
        if (Build.VERSION.SDK_INT >= 17) {
            this.setLayoutDirection(0);
        }
    }

    private void initCursorTimer() {
        this.mCursorTimerTask = new TimerTask(){

            @Override
            public void run() {
                VerificationCodeEditText.this.isCursorShowing = !VerificationCodeEditText.this.isCursorShowing;
                VerificationCodeEditText.this.postInvalidate();
            }
        };
        this.mCursorTimer = new Timer();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCursorTimer.scheduleAtFixedRate(this.mCursorTimerTask, 0L, (long)this.mCursorDuration);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCursorTimer.cancel();
    }

    public final void setCursorVisible(boolean visible) {
        super.setCursorVisible(visible);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthResult = 0;
        int heightResult = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        widthResult = widthMode == 0x40000000 ? widthSize : VerificationCodeEditText.getScreenWidth(this.getContext());
        this.mEachRectLength = (widthResult - this.mVerCodeMargin * (this.mFigures - 1)) / this.mFigures;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        heightResult = heightMode == 0x40000000 ? heightSize : this.mEachRectLength;
        this.setMeasuredDimension(widthResult, heightResult);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.requestFocus();
            this.setSelection(this.getText().length());
            this.showKeyBoard(this.getContext());
            return false;
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        int i;
        this.mCurrentPosition = this.getText().length();
        int width = this.mEachRectLength - this.getPaddingLeft() - this.getPaddingRight();
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        for (int i2 = 0; i2 < this.mFigures; ++i2) {
            canvas.save();
            int start = width * i2 + i2 * this.mVerCodeMargin;
            int end = width + start;
            if (i2 == this.mCurrentPosition) {
                canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mSelectedBackgroundPaint);
            } else {
                canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mNormalBackgroundPaint);
            }
            canvas.restore();
        }
        String value = this.getText().toString();
        for (i = 0; i < value.length(); ++i) {
            canvas.save();
            int start = width * i + i * this.mVerCodeMargin;
            float x = start + width / 2;
            TextPaint paint = this.getPaint();
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setColor(this.getCurrentTextColor());
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            float baseline = ((float)height - fontMetrics.bottom + fontMetrics.top) / 2.0f - fontMetrics.top;
            canvas.drawText(String.valueOf(value.charAt(i)), x, baseline, (Paint)paint);
            canvas.restore();
        }
        for (i = 0; i < this.mFigures; ++i) {
            canvas.save();
            float lineY = (float)height - this.mBottomLineHeight / 2.0f;
            int start = width * i + i * this.mVerCodeMargin;
            int end = width + start;
            if (i < this.mCurrentPosition) {
                canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomSelectedPaint);
            } else {
                canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomNormalPaint);
            }
            canvas.restore();
        }
        if (!this.isCursorShowing && this.isCursorVisible() && this.mCurrentPosition < this.mFigures && this.hasFocus()) {
            canvas.save();
            int startX = this.mCurrentPosition * (width + this.mVerCodeMargin) + width / 2;
            int startY = height / 4;
            int endX = startX;
            int endY = height - height / 4;
            canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, this.mCursorPaint);
            canvas.restore();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
        if (this.onCodeChangedListener != null) {
            this.onCodeChangedListener.onVerCodeChanged((CharSequence)this.getText(), start, before, count);
        }
    }

    public void afterTextChanged(Editable s) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
        if (this.getText().length() == this.mFigures) {
            if (this.onCodeChangedListener != null) {
                this.onCodeChangedListener.onInputCompleted((CharSequence)this.getText());
            }
        } else if (this.getText().length() > this.mFigures) {
            this.getText().delete(this.mFigures, this.getText().length());
        }
    }

    @Override
    public void setFigures(int figures) {
        this.mFigures = figures;
        this.postInvalidate();
    }

    @Override
    public void setVerCodeMargin(int margin) {
        this.mVerCodeMargin = margin;
        this.postInvalidate();
    }

    @Override
    public void setBottomSelectedColor(@ColorRes int bottomSelectedColor) {
        this.mBottomSelectedColor = this.getColor(bottomSelectedColor);
        this.postInvalidate();
    }

    @Override
    public void setBottomNormalColor(@ColorRes int bottomNormalColor) {
        this.mBottomSelectedColor = this.getColor(bottomNormalColor);
        this.postInvalidate();
    }

    @Override
    public void setSelectedBackgroundColor(@ColorRes int selectedBackground) {
        this.mSelectedBackgroundColor = this.getColor(selectedBackground);
        this.postInvalidate();
    }

    @Override
    public void setBottomLineHeight(int bottomLineHeight) {
        this.mBottomLineHeight = bottomLineHeight;
        this.postInvalidate();
    }

    @Override
    public void setOnVerificationCodeChangedListener(VerificationAction.OnVerificationCodeChangedListener listener) {
        this.onCodeChangedListener = listener;
    }

    private int getColor(@ColorRes int color2) {
        return ContextCompat.getColor((Context)this.getContext(), (int)color2);
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    static int getScreenWidth(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public void showKeyBoard(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput((View)this, 1);
    }

    public void toggleSoftInput(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(1, 1);
    }
}

