/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safehelper.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.SafeHelperCommonDialog;

public class VerifyPinDialog
extends SafeHelperCommonDialog
implements View.OnClickListener {
    private EditText editPinView;
    private TextView verifyPinErrorInfoView;
    private TextView verifyPinTitleView;
    private CallBack callBack;

    public VerifyPinDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.sh_dialog_verify_pin;
    }

    @Override
    public void initView() {
        super.initView();
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
        this.editPinView = (EditText)this.findViewById(R.id.edit_input_pin);
        this.verifyPinErrorInfoView = (TextView)this.findViewById(R.id.tv_verify_error_info);
        this.verifyPinTitleView = (TextView)this.findViewById(R.id.tv_verify_pin_title);
        Button btnOk = (Button)this.findViewById(R.id.btn_positive);
        btnOk.setOnClickListener((View.OnClickListener)this);
        btnOk.setText(R.string.sh_dialog_verify_pin_ok);
        Button btnCancel = (Button)this.findViewById(R.id.btn_negative);
        btnCancel.setOnClickListener((View.OnClickListener)this);
        btnCancel.setText(R.string.sh_dialog_verify_pin_cancel);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_positive) {
            this.btnOkClick();
        } else if (id2 == R.id.btn_negative) {
            this.btnCancelClick();
        }
    }

    public void setVerifyPinTitle(String title) {
        this.verifyPinTitleView.setText((CharSequence)title);
    }

    private void btnOkClick() {
        String pin = this.editPinView.getText().toString();
        this.verifyPinErrorInfoView.setVisibility(0);
        if (TextUtils.isEmpty((CharSequence)pin)) {
            this.verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_null);
            return;
        }
        if (pin.length() < 6) {
            this.verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_short);
            return;
        }
        if (pin.length() > 16) {
            this.verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_long);
            return;
        }
        this.verifyPinErrorInfoView.setVisibility(8);
        if (this.callBack != null) {
            this.callBack.okCallBack(pin);
        }
    }

    public void setVerifyPinErrorInfo(String errorInfo) {
        this.verifyPinErrorInfoView.setVisibility(0);
        this.verifyPinErrorInfoView.setText((CharSequence)errorInfo);
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    private void btnCancelClick() {
        if (this.callBack != null) {
            this.callBack.cancelCallBack();
        }
    }

    @Override
    public void show() {
        super.show();
        this.verifyPinErrorInfoView.setVisibility(8);
    }

    public static interface CallBack {
        public void okCallBack(String var1);

        public void cancelCallBack();
    }
}

