/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

import java.math.BigInteger;

public class Word {
    byte[] bytesValue = new byte[4];
    Long longValue = null;

    public Word(long l2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.bytesValue[i2] = (byte)(l2 >>> 24 - i2 * 8);
        }
        this.longValue = l2 & 0xFFFFFFFFL;
    }

    public Word(byte[] bytes) {
        this(bytes, 0);
    }

    private Word(byte[] bytes, int index) {
        this.bytesValue[0] = bytes[index];
        this.bytesValue[1] = bytes[index + 1];
        this.bytesValue[2] = bytes[index + 2];
        this.bytesValue[3] = bytes[index + 3];
        this.longValue = this.getLong();
    }

    public long getLong() {
        if (this.longValue == null) {
            long firstByte = 0L;
            long secondByte = 0L;
            long thirdByte = 0L;
            long fourthByte = 0L;
            firstByte = 0xFF & this.bytesValue[0];
            secondByte = 0xFF & this.bytesValue[1];
            thirdByte = 0xFF & this.bytesValue[2];
            fourthByte = 0xFF & this.bytesValue[3];
            long realValue = (firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
            return realValue;
        }
        return this.longValue;
    }

    public byte[] getBytes() {
        return this.bytesValue;
    }

    public Word xor(Word b2) {
        long t = this.getLong() ^ b2.getLong();
        return new Word(t);
    }

    public Word and(Word b2) {
        long t = this.getLong() & b2.getLong();
        return new Word(t);
    }

    public Word plus(Word b2) {
        long t = this.getLong() + b2.getLong();
        return new Word(t);
    }

    public Word or(Word b2) {
        long t = this.getLong() | b2.getLong();
        return new Word(t);
    }

    public Word not() {
        long t = this.getLong() ^ 0xFFFFFFFFL;
        return new Word(t);
    }

    public Word cycleLeftShift(int k2) {
        if (k2 == 32) {
            return this;
        }
        int realShift = k2 > 32 ? k2 - 32 : k2;
        long t1 = this.getLong() << realShift & 0xFFFFFFFFL;
        long t2 = this.getLong() >> 32 - realShift;
        long t = t1 | t2;
        return new Word(t);
    }

    public static Word[] split(byte[] bytes) {
        Word[] words = new Word[bytes.length / 4];
        for (int i2 = 0; i2 < words.length; ++i2) {
            words[i2] = new Word(bytes, i2 * 4);
        }
        return words;
    }

    public String toString() {
        return BigInteger.valueOf(this.getLong()).toString(16);
    }

    public Word clone() {
        return new Word(this.getLong());
    }
}

